/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.security.KeyStore;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.apache.logging.log4j.core.net.ssl.PasswordProvider;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TrustStoreConfigurationTest {
    @Test
    public void loadEmptyConfigurationDeprecated() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new TrustStoreConfiguration(null, TestConstants.NULL_PWD, null, null));
    }

    @Test
    public void loadEmptyConfiguration() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new TrustStoreConfiguration(null, (PasswordProvider)new MemoryPasswordProvider(TestConstants.NULL_PWD), null, null));
    }

    @Test
    public void loadConfigurationDeprecated() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", TestConstants.TRUSTSTORE_PWD(), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assertions.assertNotNull((Object)ks);
    }

    @Test
    public void loadConfiguration() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.TRUSTSTORE_PWD()), null, null);
        KeyStore ks = ksc.getKeyStore();
        Assertions.assertNotNull((Object)ks);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoadsDeprecated() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", TestConstants.TRUSTSTORE_PWD(), null, null);
        KeyStore ks = ksc.getKeyStore();
        KeyStore ks2 = ksc.getKeyStore();
        Assertions.assertSame((Object)ks, (Object)ks2);
    }

    @Test
    public void returnTheSameKeyStoreAfterMultipleLoads() throws StoreConfigurationException {
        TrustStoreConfiguration ksc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider(TestConstants.TRUSTSTORE_PWD()), null, null);
        KeyStore ks = ksc.getKeyStore();
        KeyStore ks2 = ksc.getKeyStore();
        Assertions.assertSame((Object)ks, (Object)ks2);
    }

    @Test
    public void wrongPasswordDeprecated() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", "wrongPassword!".toCharArray(), null, null));
    }

    @Test
    public void wrongPassword() {
        Assertions.assertThrows(StoreConfigurationException.class, () -> new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", (PasswordProvider)new MemoryPasswordProvider("wrongPassword!".toCharArray()), null, null));
    }
}

