/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.ExtendedThrowablePatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtendedThrowablePatternConverterTest {
    @Test
    public void testSuffixFromNormalPattern() {
        String suffix = "suffix(%mdc{key})";
        ThreadContext.put((String)"key", (String)"test suffix ");
        String[] options = new String[]{"suffix(%mdc{key})"};
        ExtendedThrowablePatternConverter converter = ExtendedThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertTrue((boolean)result.contains("test suffix"), (String)"No suffix");
    }

    @Test
    public void testSuffix() {
        String suffix = "suffix(test suffix)";
        String[] options = new String[]{"suffix(test suffix)"};
        ExtendedThrowablePatternConverter converter = ExtendedThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertTrue((boolean)result.contains("test suffix"), (String)"No suffix");
    }

    @Test
    public void testSuffixWillIgnoreThrowablePattern() {
        String suffix = "suffix(%xEx{suffix(inner suffix)})";
        String[] options = new String[]{"suffix(%xEx{suffix(inner suffix)})"};
        ExtendedThrowablePatternConverter converter = ExtendedThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertFalse((boolean)result.contains("inner suffix"), (String)"Has unexpected suffix");
    }

    @Test
    public void testDeserializedLogEventWithThrowableProxyButNoThrowable() {
        ExtendedThrowablePatternConverter converter = ExtendedThrowablePatternConverter.newInstance(null, null);
        Exception originalThrowable = new Exception("something bad happened");
        ThrowableProxy throwableProxy = new ThrowableProxy((Throwable)originalThrowable);
        Throwable deserializedThrowable = null;
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("")).setThrown(deserializedThrowable).setThrownProxy(throwableProxy).setTimeMillis(0L).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertTrue((boolean)result.contains(originalThrowable.getMessage()), (String)result);
        Assertions.assertTrue((boolean)result.contains(originalThrowable.getStackTrace()[0].getMethodName()), (String)result);
    }

    @Test
    public void testFiltering() {
        String packages = "filters(org.junit, org.apache.maven, sun.reflect, java.lang.reflect)";
        String[] options = new String[]{"filters(org.junit, org.apache.maven, sun.reflect, java.lang.reflect)"};
        ExtendedThrowablePatternConverter converter = ExtendedThrowablePatternConverter.newInstance(null, (String[])options);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String result = sb.toString();
        Assertions.assertTrue((boolean)result.contains(" suppressed "), (String)"No suppressed lines");
    }

    @Test
    public void testFull() {
        ExtendedThrowablePatternConverter converter = ExtendedThrowablePatternConverter.newInstance(null, null);
        NullPointerException cause = new NullPointerException("null pointer");
        IllegalArgumentException parent = new IllegalArgumentException("IllegalArgument", cause);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("testLogger").setLoggerFqcn(this.getClass().getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("test exception")).setThrown((Throwable)parent).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        parent.printStackTrace(pw);
        String result = sb.toString();
        result = result.replaceAll(" ~?\\[.*\\]", "");
        String expected = sw.toString();
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testFiltersAndSeparator() {
        ExtendedThrowablePatternConverter exConverter = ExtendedThrowablePatternConverter.newInstance(null, (String[])new String[]{"full", "filters(org.junit,org.eclipse)", "separator(|)"});
        ThrowableFormatOptions options = exConverter.getOptions();
        List ignorePackages = options.getIgnorePackages();
        Assertions.assertNotNull((Object)ignorePackages);
        String ignorePackagesString = ignorePackages.toString();
        Assertions.assertTrue((boolean)ignorePackages.contains("org.junit"), (String)ignorePackagesString);
        Assertions.assertTrue((boolean)ignorePackages.contains("org.eclipse"), (String)ignorePackagesString);
        Assertions.assertEquals((Object)"|", (Object)options.getSeparator());
    }
}

