/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.NdcPatternConverter;
import org.apache.logging.log4j.junit.UsingThreadContextStack;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@UsingThreadContextStack
public class NdcPatternConverterTest {
    @Test
    public void testEmpty() {
        this.testConverter("[]");
    }

    @Test
    public void test1() {
        ThreadContext.push((String)"foo");
        this.testConverter("[foo]");
    }

    @Test
    public void test2() {
        ThreadContext.push((String)"foo");
        ThreadContext.push((String)"bar");
        this.testConverter("[foo, bar]");
    }

    @Test
    public void test3() {
        ThreadContext.push((String)"foo");
        ThreadContext.push((String)"bar");
        ThreadContext.push((String)"baz");
        this.testConverter("[foo, bar, baz]");
    }

    private void testConverter(String expected) {
        SimpleMessage msg = new SimpleMessage("Hello");
        NdcPatternConverter converter = NdcPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        Assertions.assertEquals((Object)expected, (Object)str);
    }
}

