/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.RegexReplacementConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexReplacementConverterTest {
    @Test
    public void testReplacement() {
        ThreadContext.put((String)"MyKey", (String)"Apache");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(RegexReplacementConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("This is a test")).build();
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        String[] options = new String[]{"%logger %msg%n", "\\.", "/"};
        RegexReplacementConverter converter = RegexReplacementConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        Assertions.assertNotNull((Object)converter);
        converter.format((LogEvent)event, sb);
        Assertions.assertEquals((Object)("org/apache/logging/log4j/core/pattern/RegexReplacementConverterTest This is a test" + Strings.LINE_SEPARATOR), (Object)sb.toString());
    }
}

