/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ThreadContextDataInjector;
import org.apache.logging.log4j.core.util.ContextDataProvider;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class ContextDataProviderTest {
    private static Logger logger;
    private static ListAppender appender;

    @BeforeAll
    public static void beforeClass() {
        ThreadContextDataInjector.contextDataProviders.add(new TestContextDataProvider());
        System.setProperty("log4j.configurationFile", "log4j-contextData.xml");
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        logger = loggerContext.getLogger(ContextDataProviderTest.class.getName());
        appender = (ListAppender)loggerContext.getConfiguration().getAppender("List");
        Assertions.assertNotNull((Object)((Object)appender), (String)"No List appender");
    }

    @Test
    public void testContextProvider() {
        ThreadContext.put((String)"loginId", (String)"jdoe");
        logger.debug("This is a test");
        List<String> messages = appender.getMessages();
        Assertions.assertEquals((int)1, (int)messages.size(), (String)"Incorrect number of messages");
        Assertions.assertTrue((boolean)messages.get(0).contains("testKey=testValue"), (String)"Context data missing");
    }

    private static class TestContextDataProvider
    implements ContextDataProvider {
        private TestContextDataProvider() {
        }

        public Map<String, String> supplyContextData() {
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("testKey", "testValue");
            return contextData;
        }
    }
}

