/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.net.URI;
import org.apache.logging.log4j.core.util.NetUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class NetUtilsTest {
    @Test
    public void testToUriWithoutBackslashes() {
        String config = "file:///path/to/something/on/unix";
        URI uri = NetUtils.toURI((String)"file:///path/to/something/on/unix");
        Assertions.assertNotNull((Object)uri, (String)"The URI should not be null.");
        Assertions.assertEquals((Object)"file:///path/to/something/on/unix", (Object)uri.toString(), (String)"The URI is not correct.");
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    public void testToUriWindowsWithBackslashes() {
        String config = "file:///D:\\path\\to\\something/on/windows";
        URI uri = NetUtils.toURI((String)"file:///D:\\path\\to\\something/on/windows");
        Assertions.assertNotNull((Object)uri, (String)"The URI should not be null.");
        Assertions.assertEquals((Object)"file:///D:/path/to/something/on/windows", (Object)uri.toString(), (String)"The URI is not correct.");
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    public void testToUriWindowsAbsolutePath() {
        String config = "D:\\path\\to\\something\\on\\windows";
        URI uri = NetUtils.toURI((String)"D:\\path\\to\\something\\on\\windows");
        Assertions.assertNotNull((Object)uri, (String)"The URI should not be null.");
        Assertions.assertEquals((Object)"file:/D:/path/to/something/on/windows", (Object)uri.toString(), (String)"The URI is not correct.");
    }
}

