/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.spi.AbstractLogger;

@Configurable(printObject=true)
@Plugin(value="asyncLogger")
public class AsyncLoggerConfig
extends LoggerConfig {
    private static final ThreadLocal<Boolean> ASYNC_LOGGER_ENTERED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final AsyncLoggerConfigDelegate delegate;

    @PluginFactory
    public static <B extends Builder<B>> B newAsyncBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    protected AsyncLoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation, LogEventFactory logEventFactory) {
        super(name, appenders, filter, level, additive, properties, config, includeLocation, logEventFactory);
        this.delegate = config.getAsyncLoggerConfigDelegate();
        this.delegate.setLogEventFactory(this.getLogEventFactory());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void log(LogEvent event, LoggerConfig.LoggerConfigPredicate predicate) {
        if (predicate == LoggerConfig.LoggerConfigPredicate.ALL && ASYNC_LOGGER_ENTERED.get() == Boolean.FALSE && this.hasAppenders()) {
            ASYNC_LOGGER_ENTERED.set(Boolean.TRUE);
            try {
                if (this.isFiltered(event)) return;
                this.processLogEvent(event, LoggerConfig.LoggerConfigPredicate.SYNCHRONOUS_ONLY);
                this.logToAsyncDelegate(event);
                return;
            }
            finally {
                ASYNC_LOGGER_ENTERED.set(Boolean.FALSE);
            }
        } else {
            super.log(event, predicate);
        }
    }

    AsyncLoggerConfigDelegate getAsyncLoggerConfigDelegate() {
        return this.delegate;
    }

    @Override
    protected void callAppenders(LogEvent event) {
        super.callAppenders(event);
    }

    private void logToAsyncDelegate(LogEvent event) {
        this.populateLazilyInitializedFields(event);
        if (!this.delegate.tryEnqueue(event, this)) {
            this.handleQueueFull(event);
        }
    }

    private void handleQueueFull(LogEvent event) {
        if (AbstractLogger.getRecursionDepth() > 1) {
            AsyncQueueFullMessageUtil.logWarningToStatusLogger();
            this.logToAsyncLoggerConfigsOnCurrentThread(event);
        } else {
            EventRoute eventRoute = this.delegate.getEventRoute(event.getLevel());
            eventRoute.logMessage(this, event);
        }
    }

    private void populateLazilyInitializedFields(LogEvent event) {
        event.getSource();
        event.getThreadName();
    }

    void logInBackgroundThread(LogEvent event) {
        this.delegate.enqueueEvent(event, this);
    }

    void logToAsyncLoggerConfigsOnCurrentThread(LogEvent event) {
        this.processLogEvent(event, LoggerConfig.LoggerConfigPredicate.ASYNCHRONOUS_ONLY);
    }

    private String displayName() {
        return "".equals(this.getName()) ? "root" : this.getName();
    }

    @Override
    public void start() {
        LOGGER.trace("AsyncLoggerConfig[{}] starting...", (Object)this.displayName());
        super.start();
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        LOGGER.trace("AsyncLoggerConfig[{}] stopping...", (Object)this.displayName());
        this.setStopped();
        return true;
    }

    public RingBufferAdmin createRingBufferAdmin(String contextName) {
        return this.delegate.createRingBufferAdmin(contextName, this.getName());
    }

    protected static boolean includeLocation(String includeLocationConfigValue) {
        return Boolean.parseBoolean(includeLocationConfigValue);
    }

    public static class Builder<B extends Builder<B>>
    extends LoggerConfig.Builder<B> {
        @Override
        public LoggerConfig build() {
            String name = this.getLoggerName().equals("root") ? "" : this.getLoggerName();
            LoggerConfig.LevelAndRefs container = AsyncLoggerConfig.getLevelAndRefs(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
            return new AsyncLoggerConfig(name, container.refs, this.getFilter(), container.level, this.isAdditivity(), this.getProperties(), this.getConfig(), AsyncLoggerConfig.includeLocation(this.getIncludeLocation()), this.getLogEventFactory());
        }
    }

    @Configurable(printObject=true)
    @Plugin(value="asyncRoot")
    public static class RootLogger
    extends LoggerConfig {
        @PluginFactory
        public static <B extends Builder<B>> B newAsyncRootBuilder() {
            return (B)((Builder)new Builder().asBuilder());
        }

        public static class Builder<B extends Builder<B>>
        extends LoggerConfig.RootLogger.Builder<B> {
            @Override
            public LoggerConfig build() {
                LoggerConfig.LevelAndRefs container = RootLogger.getLevelAndRefs(this.getLevel(), this.getRefs(), this.getLevelAndRefs(), this.getConfig());
                return new AsyncLoggerConfig("", container.refs, this.getFilter(), container.level, this.isAdditivity(), this.getProperties(), this.getConfig(), AsyncLoggerConfig.includeLocation(this.getIncludeLocation()), this.getLogEventFactory());
            }
        }
    }
}

