/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

public class RegionHistorian
implements HConstants {
    private static final Log LOG = LogFactory.getLog(RegionHistorian.class);
    private HTable metaTable;
    private static RegionHistorian historian;
    static SimpleDateFormat dateFormat;
    public static final String SPLIT_PREFIX = "Region split from: ";
    public static final long FIXED_OVERHEAD;

    private RegionHistorian() {
    }

    public static synchronized RegionHistorian getInstance() {
        if (historian == null) {
            historian = new RegionHistorian();
        }
        return historian;
    }

    public List<RegionHistoryInformation> getRegionHistory(byte[] regionName) {
        if (!this.isOnline()) {
            return null;
        }
        ArrayList<RegionHistoryInformation> informations = new ArrayList<RegionHistoryInformation>();
        try {
            for (HistorianQualifierKey keyEnu : HistorianQualifierKey.values()) {
                byte[] columnKey = keyEnu.key;
                Get get2 = new Get(regionName);
                get2.addColumn(CATALOG_HISTORIAN_FAMILY, columnKey);
                get2.setMaxVersions(Integer.MAX_VALUE);
                Result result = this.metaTable.get(get2);
                if (result == null) continue;
                for (KeyValue kv : result.raw()) {
                    RegionHistorian regionHistorian = historian;
                    regionHistorian.getClass();
                    informations.add(regionHistorian.new RegionHistoryInformation(kv.getTimestamp(), columnKey, kv.getValue()));
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Unable to retrieve region history", (Throwable)ioe);
        }
        Collections.sort(informations);
        return informations;
    }

    public void addRegionAssignment(HRegionInfo info, String serverName) {
        this.add(HistorianQualifierKey.REGION_ASSIGNMENT.key, "Region assigned to server " + serverName, info);
    }

    public void addRegionCreation(HRegionInfo info) {
        this.add(HistorianQualifierKey.REGION_CREATION.key, "Region creation", info);
    }

    public void addRegionOpen(HRegionInfo info, HServerAddress address) {
        this.add(HistorianQualifierKey.REGION_OPEN.key, "Region opened on server : " + address.getHostname(), info);
    }

    public void addRegionSplit(HRegionInfo oldInfo, HRegionInfo newInfo1, HRegionInfo newInfo2) {
        HRegionInfo[] infos;
        for (HRegionInfo info : infos = new HRegionInfo[]{newInfo1, newInfo2}) {
            this.add(HistorianQualifierKey.REGION_SPLIT.key, SPLIT_PREFIX + oldInfo.getRegionNameAsString(), info);
        }
    }

    public void addRegionCompaction(HRegionInfo info, String timeTaken) {
        if (LOG.isDebugEnabled()) {
            this.add(HistorianQualifierKey.REGION_COMPACTION.key, "Region compaction completed in " + timeTaken, info);
        }
    }

    public void addRegionFlush(HRegionInfo info, String timeTaken) {
    }

    private void add(byte[] qualifier, String text, HRegionInfo info) {
        this.add(qualifier, text, info, Long.MAX_VALUE);
    }

    private void add(byte[] qualifier, String text, HRegionInfo info, long timestamp) {
        if (!this.isOnline()) {
            return;
        }
        if (!info.isMetaRegion()) {
            Put put = new Put(info.getRegionName());
            put.setTimeStamp(timestamp);
            put.add(HConstants.CATALOG_HISTORIAN_FAMILY, qualifier, Bytes.toBytes(text));
            try {
                this.metaTable.put(put);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Unable to '" + text + "'"), (Throwable)ioe);
            }
        }
    }

    public boolean isOnline() {
        return this.metaTable != null;
    }

    public void online(HBaseConfiguration c) {
        try {
            this.metaTable = new HTable(c, META_TABLE_NAME);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Onlined");
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"Unable to create RegionHistorian", (Throwable)ioe);
        }
    }

    public void offline() {
        this.metaTable = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Offlined");
        }
    }

    static {
        dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + ClassSize.REFERENCE);
    }

    public class RegionHistoryInformation
    implements Comparable<RegionHistoryInformation> {
        private GregorianCalendar cal = new GregorianCalendar();
        private long timestamp;
        private byte[] event = null;
        private byte[] description = null;

        public RegionHistoryInformation(long timestamp, byte[] event, byte[] description) {
            this.timestamp = timestamp;
            this.event = event;
            this.description = description;
        }

        @Override
        public int compareTo(RegionHistoryInformation otherInfo) {
            return -1 * Long.valueOf(this.timestamp).compareTo(otherInfo.getTimestamp());
        }

        public String getEvent() {
            return Bytes.toString(this.event);
        }

        public String getDescription() {
            return Bytes.toString(this.description);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getTimestampAsString() {
            this.cal.setTimeInMillis(this.timestamp);
            return dateFormat.format(this.cal.getTime());
        }
    }

    private static enum HistorianQualifierKey {
        REGION_CREATION(Bytes.toBytes("creation")),
        REGION_OPEN(Bytes.toBytes("open")),
        REGION_SPLIT(Bytes.toBytes("split")),
        REGION_COMPACTION(Bytes.toBytes("compaction")),
        REGION_FLUSH(Bytes.toBytes("flush")),
        REGION_ASSIGNMENT(Bytes.toBytes("assignment"));

        byte[] key;

        private HistorianQualifierKey(byte[] key) {
            this.key = key;
        }
    }
}

