/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class Delete
implements Writable {
    private byte[] row = null;
    private long ts;
    private long lockId = -1L;
    private final Map<byte[], List<KeyValue>> familyMap = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);

    public Delete() {
        this((byte[])null);
    }

    public Delete(byte[] row) {
        this(row, Long.MAX_VALUE, null);
    }

    public Delete(byte[] row, long timestamp, RowLock rowLock) {
        this.row = row;
        this.ts = timestamp;
        if (rowLock != null) {
            this.lockId = rowLock.getLockId();
        }
    }

    public Delete(Delete d) {
        this.row = d.getRow();
        this.ts = d.getTimeStamp();
        this.lockId = d.getLockId();
        this.familyMap.putAll(d.getFamilyMap());
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    public Delete deleteFamily(byte[] family) {
        this.deleteFamily(family, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteFamily(byte[] family, long timestamp) {
        List<KeyValue> list = this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        } else if (!list.isEmpty()) {
            list.clear();
        }
        list.add(new KeyValue(this.row, family, null, timestamp, KeyValue.Type.DeleteFamily));
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteColumns(byte[] family, byte[] qualifier) {
        this.deleteColumns(family, qualifier, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteColumns(byte[] family, byte[] qualifier, long timestamp) {
        List<KeyValue> list = this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.DeleteColumn));
        this.familyMap.put(family, list);
        return this;
    }

    public Delete deleteColumns(byte[] column, long timestamp) {
        byte[][] parts = KeyValue.parseColumn(column);
        this.deleteColumns(parts[0], parts[1], timestamp);
        return this;
    }

    public Delete deleteColumn(byte[] family, byte[] qualifier) {
        this.deleteColumn(family, qualifier, Long.MAX_VALUE);
        return this;
    }

    public Delete deleteColumn(byte[] family, byte[] qualifier, long timestamp) {
        List<KeyValue> list = this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, qualifier, timestamp, KeyValue.Type.Delete));
        this.familyMap.put(family, list);
        return this;
    }

    public void deleteColumns(byte[] column) {
        byte[][] parts = KeyValue.parseColumn(column);
        this.deleteColumns(parts[0], parts[1]);
    }

    public Delete deleteColumn(byte[] column) {
        byte[][] parts = KeyValue.parseColumn(column);
        this.deleteColumn(parts[0], parts[1], Long.MAX_VALUE);
        return this;
    }

    public Map<byte[], List<KeyValue>> getFamilyMap() {
        return this.familyMap;
    }

    public byte[] getRow() {
        return this.row;
    }

    public RowLock getRowLock() {
        return new RowLock(this.row, this.lockId);
    }

    public long getLockId() {
        return this.lockId;
    }

    public long getTimeStamp() {
        return this.ts;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("row=");
        sb.append(Bytes.toString(this.row));
        sb.append(", ts=");
        sb.append(this.ts);
        sb.append(", families={");
        boolean moreThanOne = false;
        for (Map.Entry<byte[], List<KeyValue>> entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append("(family=");
            sb.append(Bytes.toString(entry.getKey()));
            sb.append(", keyvalues=(");
            boolean moreThanOneB = false;
            for (KeyValue kv : entry.getValue()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(kv.toString());
            }
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.row = Bytes.readByteArray(in);
        this.ts = in.readLong();
        this.lockId = in.readLong();
        this.familyMap.clear();
        int numFamilies = in.readInt();
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = in.readInt();
            ArrayList<KeyValue> list = new ArrayList<KeyValue>(numColumns);
            for (int j = 0; j < numColumns; ++j) {
                KeyValue kv = new KeyValue();
                kv.readFields(in);
                list.add(kv);
            }
            this.familyMap.put(family, list);
        }
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.ts);
        out.writeLong(this.lockId);
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], List<KeyValue>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            List<KeyValue> list = entry.getValue();
            out.writeInt(list.size());
            for (KeyValue kv : list) {
                kv.write(out);
            }
        }
    }
}

