/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Scanner;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerTimeoutException;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.UnmodifyableHRegionInfo;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.filter.StopRowFilter;
import org.apache.hadoop.hbase.filter.WhileMatchRowFilter;
import org.apache.hadoop.hbase.io.BatchOperation;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;

public class HTable {
    private final HConnection connection;
    private final byte[] tableName;
    protected final int scannerTimeout;
    private volatile HBaseConfiguration configuration;
    private ArrayList<Put> writeBuffer;
    private long writeBufferSize;
    private boolean autoFlush;
    private long currentWriteBufferSize;
    protected int scannerCaching;

    public HTable(String tableName) throws IOException {
        this(new HBaseConfiguration(), Bytes.toBytes(tableName));
    }

    public HTable(byte[] tableName) throws IOException {
        this(new HBaseConfiguration(), tableName);
    }

    public HTable(HBaseConfiguration conf, String tableName) throws IOException {
        this(conf, Bytes.toBytes(tableName));
    }

    public HTable(HBaseConfiguration conf, byte[] tableName) throws IOException {
        this.tableName = tableName;
        if (conf == null) {
            this.scannerTimeout = 0;
            this.connection = null;
            return;
        }
        this.connection = HConnectionManager.getConnection(conf);
        this.scannerTimeout = conf.getInt("hbase.regionserver.lease.period", 60000);
        this.configuration = conf;
        this.connection.locateRegion(tableName, HConstants.EMPTY_START_ROW);
        this.writeBuffer = new ArrayList();
        this.writeBufferSize = conf.getLong("hbase.client.write.buffer", 0x200000L);
        this.autoFlush = true;
        this.currentWriteBufferSize = 0L;
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", 1);
    }

    public static boolean isTableEnabled(String tableName) throws IOException {
        return HTable.isTableEnabled(Bytes.toBytes(tableName));
    }

    public static boolean isTableEnabled(byte[] tableName) throws IOException {
        return HTable.isTableEnabled(new HBaseConfiguration(), tableName);
    }

    public static boolean isTableEnabled(HBaseConfiguration conf, String tableName) throws IOException {
        return HTable.isTableEnabled(conf, Bytes.toBytes(tableName));
    }

    public static boolean isTableEnabled(HBaseConfiguration conf, byte[] tableName) throws IOException {
        return HConnectionManager.getConnection(conf).isTableEnabled(tableName);
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, Bytes.toBytes(row), false);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, false);
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public HConnection getConnection() {
        return this.connection;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public void setScannerCaching(int scannerCaching) {
        this.scannerCaching = scannerCaching;
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return new UnmodifyableHTableDescriptor(this.connection.getHTableDescriptor(this.tableName));
    }

    public byte[][] getStartKeys() throws IOException {
        return this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        final ArrayList startKeyList = new ArrayList();
        final ArrayList endKeyList = new ArrayList();
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            @Override
            public boolean processRow(Result rowResult) throws IOException {
                HRegionInfo info = Writables.getHRegionInfo(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                if (Bytes.equals(info.getTableDesc().getName(), HTable.this.getTableName()) && !info.isOffline() && !info.isSplit()) {
                    startKeyList.add(info.getStartKey());
                    endKeyList.add(info.getEndKey());
                }
                return true;
            }
        };
        MetaScanner.metaScan(this.configuration, visitor, this.tableName);
        return new Pair<T[], T[]>(startKeyList.toArray((T[])new byte[startKeyList.size()][]), endKeyList.toArray((T[])new byte[endKeyList.size()][]));
    }

    public Map<HRegionInfo, HServerAddress> getRegionsInfo() throws IOException {
        final TreeMap<HRegionInfo, HServerAddress> regionMap = new TreeMap<HRegionInfo, HServerAddress>();
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            @Override
            public boolean processRow(Result rowResult) throws IOException {
                HRegionInfo info = Writables.getHRegionInfo(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                if (!Bytes.equals(info.getTableDesc().getName(), HTable.this.getTableName())) {
                    return false;
                }
                HServerAddress server = new HServerAddress();
                byte[] value = rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                if (value != null && value.length > 0) {
                    String address = Bytes.toString(value);
                    server = new HServerAddress(address);
                }
                if (!info.isOffline() && !info.isSplit()) {
                    regionMap.put(new UnmodifyableHRegionInfo(info), server);
                }
                return true;
            }
        };
        MetaScanner.metaScan(this.configuration, visitor, this.tableName);
        return regionMap;
    }

    public Result getRowOrBefore(byte[] row, final byte[] family) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Result>(this.connection, this.tableName, row){

            @Override
            public Result call() throws IOException {
                return this.server.getClosestRowBefore(this.location.getRegionInfo().getRegionName(), this.row, family);
            }
        });
    }

    public RowResult getClosestRowBefore(byte[] row, byte[] family) throws IOException {
        Result r = this.getRowOrBefore(row, family);
        return r == null || r.isEmpty() ? null : r.getRowResult();
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        ClientScanner s = new ClientScanner(scan);
        s.initialize();
        return s;
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    public Result get(final Get get2) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Result>(this.connection, this.tableName, get2.getRow()){

            @Override
            public Result call() throws IOException {
                return this.server.get(this.location.getRegionInfo().getRegionName(), get2);
            }
        });
    }

    public void delete(final Delete delete) throws IOException {
        this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, delete.getRow()){

            @Override
            public Boolean call() throws IOException {
                this.server.delete(this.location.getRegionInfo().getRegionName(), delete);
                return null;
            }
        });
    }

    public synchronized void put(Put put) throws IOException {
        this.validatePut(put);
        this.writeBuffer.add(put);
        this.currentWriteBufferSize += put.heapSize();
        if (this.autoFlush || this.currentWriteBufferSize > this.writeBufferSize) {
            this.flushCommits();
        }
    }

    public synchronized void put(List<Put> puts) throws IOException {
        for (Put put : puts) {
            this.validatePut(put);
            this.writeBuffer.add(put);
            this.currentWriteBufferSize += put.heapSize();
        }
        if (this.autoFlush || this.currentWriteBufferSize > this.writeBufferSize) {
            this.flushCommits();
        }
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, true);
    }

    public long incrementColumnValue(byte[] row, final byte[] family, final byte[] qualifier, final long amount, final boolean writeToWAL) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("column is null");
        }
        if (npe != null) {
            IOException io = new IOException("Invalid arguments to incrementColumnValue", npe);
            throw io;
        }
        return this.connection.getRegionServerWithRetries(new ServerCallable<Long>(this.connection, this.tableName, row){

            @Override
            public Long call() throws IOException {
                return this.server.incrementColumnValue(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, amount, writeToWAL);
            }
        });
    }

    public synchronized boolean checkAndPut(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Put put) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, row){

            @Override
            public Boolean call() throws IOException {
                return this.server.checkAndPut(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, value, put) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public boolean exists(final Get get2) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, get2.getRow()){

            @Override
            public Boolean call() throws IOException {
                return this.server.exists(this.location.getRegionInfo().getRegionName(), get2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCommits() throws IOException {
        try {
            this.connection.processBatchOfRows(this.writeBuffer, this.tableName);
        }
        finally {
            this.currentWriteBufferSize = 0L;
            this.writeBuffer.clear();
        }
    }

    public void close() throws IOException {
        this.flushCommits();
    }

    private void validatePut(Put put) throws IllegalArgumentException {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
    }

    public RowLock lockRow(byte[] row) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<RowLock>(this.connection, this.tableName, row){

            @Override
            public RowLock call() throws IOException {
                long lockId = this.server.lockRow(this.location.getRegionInfo().getRegionName(), this.row);
                RowLock rowLock = new RowLock(this.row, lockId);
                return rowLock;
            }
        });
    }

    public void unlockRow(final RowLock rl) throws IOException {
        this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, rl.getRow()){

            @Override
            public Boolean call() throws IOException {
                this.server.unlockRow(this.location.getRegionInfo().getRegionName(), rl.getLockId());
                return null;
            }
        });
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flushCommits();
        }
    }

    public ArrayList<Put> getWriteBuffer() {
        return this.writeBuffer;
    }

    public Cell get(String row, String column) throws IOException {
        return this.get(Bytes.toBytes(row), Bytes.toBytes(column));
    }

    public Cell[] get(String row, String column, int numVersions) throws IOException {
        return this.get(Bytes.toBytes(row), Bytes.toBytes(column), numVersions);
    }

    public Cell get(byte[] row, byte[] column) throws IOException {
        Get g = new Get(row);
        byte[][] fq = KeyValue.parseColumn(column);
        g.addColumn(fq[0], fq[1]);
        Result r = this.get(g);
        return r == null || r.size() <= 0 ? null : r.getCellValue();
    }

    public Cell[] get(byte[] row, byte[] column, int numVersions) throws IOException {
        return this.get(row, column, Long.MAX_VALUE, numVersions);
    }

    public Cell[] get(String row, String column, long timestamp, int numVersions) throws IOException {
        return this.get(Bytes.toBytes(row), Bytes.toBytes(column), timestamp, numVersions);
    }

    public Cell[] get(byte[] row, byte[] column, long timestamp, int numVersions) throws IOException {
        Result r;
        Get g = new Get(row);
        byte[][] fq = KeyValue.parseColumn(column);
        if (fq[1].length == 0) {
            g.addFamily(fq[0]);
        } else {
            g.addColumn(fq[0], fq[1]);
        }
        g.setMaxVersions(numVersions);
        if (timestamp != Long.MAX_VALUE) {
            g.setTimeStamp(timestamp);
        }
        return (r = this.get(g)) == null || r.size() <= 0 ? null : r.getCellValues();
    }

    public RowResult getRow(String row) throws IOException {
        return this.getRow(Bytes.toBytes(row));
    }

    public RowResult getRow(byte[] row) throws IOException {
        return this.getRow(row, Long.MAX_VALUE);
    }

    public RowResult getRow(String row, int numVersions) throws IOException {
        return this.getRow(Bytes.toBytes(row), (byte[][])null, Long.MAX_VALUE, numVersions, null);
    }

    public RowResult getRow(byte[] row, int numVersions) throws IOException {
        return this.getRow(row, (byte[][])null, Long.MAX_VALUE, numVersions, null);
    }

    public RowResult getRow(String row, long ts) throws IOException {
        return this.getRow(Bytes.toBytes(row), ts);
    }

    public RowResult getRow(byte[] row, long ts) throws IOException {
        return this.getRow(row, (byte[][])null, ts);
    }

    public RowResult getRow(String row, long ts, int numVersions) throws IOException {
        return this.getRow(Bytes.toBytes(row), (byte[][])null, ts, numVersions, null);
    }

    public RowResult getRow(byte[] row, long timestamp, int numVersions) throws IOException {
        return this.getRow(row, (byte[][])null, timestamp, numVersions, null);
    }

    public RowResult getRow(String row, String[] columns) throws IOException {
        return this.getRow(Bytes.toBytes(row), Bytes.toByteArrays(columns));
    }

    public RowResult getRow(byte[] row, byte[][] columns) throws IOException {
        return this.getRow(row, columns, Long.MAX_VALUE);
    }

    public RowResult getRow(String row, String[] columns, int numVersions) throws IOException {
        return this.getRow(Bytes.toBytes(row), Bytes.toByteArrays(columns), Long.MAX_VALUE, numVersions, null);
    }

    public RowResult getRow(byte[] row, byte[][] columns, int numVersions) throws IOException {
        return this.getRow(row, columns, Long.MAX_VALUE, numVersions, null);
    }

    public RowResult getRow(String row, String[] columns, long ts) throws IOException {
        return this.getRow(Bytes.toBytes(row), Bytes.toByteArrays(columns), ts);
    }

    public RowResult getRow(byte[] row, byte[][] columns, long ts) throws IOException {
        return this.getRow(row, columns, ts, 1, null);
    }

    public RowResult getRow(String row, String[] columns, long timestamp, int numVersions, RowLock rowLock) throws IOException {
        return this.getRow(Bytes.toBytes(row), Bytes.toByteArrays(columns), timestamp, numVersions, rowLock);
    }

    public RowResult getRow(byte[] row, byte[][] columns, long ts, int numVersions, RowLock rl) throws IOException {
        Result r;
        Get g;
        Get get2 = g = rl != null ? new Get(row, rl) : new Get(row);
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                byte[][] splits = KeyValue.parseColumn(columns[i]);
                if (splits[1].length == 0) {
                    g.addFamily(splits[0]);
                    continue;
                }
                g.addColumn(splits[0], splits[1]);
            }
        }
        g.setMaxVersions(numVersions);
        if (ts != Long.MAX_VALUE) {
            g.setTimeStamp(ts);
        }
        return (r = this.get(g)) == null || r.size() <= 0 ? null : r.getRowResult();
    }

    public Scanner getScanner(String[] columns) throws IOException {
        return this.getScanner(Bytes.toByteArrays(columns), HConstants.EMPTY_START_ROW);
    }

    public Scanner getScanner(String[] columns, String startRow) throws IOException {
        return this.getScanner(Bytes.toByteArrays(columns), Bytes.toBytes(startRow));
    }

    public Scanner getScanner(byte[][] columns) throws IOException {
        return this.getScanner(columns, HConstants.EMPTY_START_ROW, Long.MAX_VALUE, null);
    }

    public Scanner getScanner(byte[][] columns, byte[] startRow) throws IOException {
        return this.getScanner(columns, startRow, Long.MAX_VALUE, null);
    }

    public Scanner getScanner(byte[][] columns, byte[] startRow, long timestamp) throws IOException {
        return this.getScanner(columns, startRow, timestamp, null);
    }

    public Scanner getScanner(byte[][] columns, byte[] startRow, RowFilterInterface filter) throws IOException {
        return this.getScanner(columns, startRow, Long.MAX_VALUE, filter);
    }

    public Scanner getScanner(byte[][] columns, byte[] startRow, byte[] stopRow) throws IOException {
        return this.getScanner(columns, startRow, stopRow, Long.MAX_VALUE);
    }

    public Scanner getScanner(String[] columns, String startRow, String stopRow, long timestamp) throws IOException {
        return this.getScanner(Bytes.toByteArrays(columns), Bytes.toBytes(startRow), Bytes.toBytes(stopRow), timestamp);
    }

    public Scanner getScanner(byte[][] columns, byte[] startRow, byte[] stopRow, long timestamp) throws IOException {
        return this.getScanner(columns, startRow, timestamp, (RowFilterInterface)new WhileMatchRowFilter(new StopRowFilter(stopRow)));
    }

    public Scanner getScanner(String[] columns, String startRow, long timestamp, RowFilterInterface filter) throws IOException {
        return this.getScanner(Bytes.toByteArrays(columns), Bytes.toBytes(startRow), timestamp, filter);
    }

    public Scanner getScanner(byte[][] columns, byte[] startRow, long timestamp, RowFilterInterface filter) throws IOException {
        Scan scan = filter == null ? new Scan(startRow) : (filter instanceof WhileMatchRowFilter && ((WhileMatchRowFilter)filter).getInternalFilter() instanceof StopRowFilter ? new Scan(startRow, ((StopRowFilter)((WhileMatchRowFilter)filter).getInternalFilter()).getStopRowKey()) : null);
        for (int i = 0; i < columns.length; ++i) {
            byte[][] splits = KeyValue.parseColumn(columns[i]);
            if (splits[1].length == 0) {
                scan.addFamily(splits[0]);
                continue;
            }
            scan.addColumn(splits[0], splits[1]);
        }
        OldClientScanner s = new OldClientScanner(new ClientScanner(scan));
        s.initialize();
        return s;
    }

    public void deleteAll(byte[] row) throws IOException {
        this.deleteAll(row, null);
    }

    public void deleteAll(String row) throws IOException {
        this.deleteAll(row, null);
    }

    public void deleteAll(byte[] row, byte[] column) throws IOException {
        this.deleteAll(row, column, Long.MAX_VALUE);
    }

    public void deleteAll(byte[] row, long ts) throws IOException {
        this.deleteAll(row, null, ts);
    }

    public void deleteAll(String row, long ts) throws IOException {
        this.deleteAll(row, null, ts);
    }

    public void deleteAll(String row, String column) throws IOException {
        this.deleteAll(row, column, Long.MAX_VALUE);
    }

    public void deleteAll(String row, String column, long ts) throws IOException {
        this.deleteAll(Bytes.toBytes(row), column != null ? Bytes.toBytes(column) : null, ts);
    }

    public void deleteAll(byte[] row, byte[] column, long ts) throws IOException {
        this.deleteAll(row, column, ts, null);
    }

    public void deleteAll(byte[] row, byte[] column, long ts, RowLock rl) throws IOException {
        Delete d = new Delete(row, ts, rl);
        if (column != null) {
            d.deleteColumns(column, ts);
        }
        this.delete(d);
    }

    public void deleteAllByRegex(String row, String colRegex) throws IOException {
        this.deleteAllByRegex(row, colRegex, Long.MAX_VALUE);
    }

    public void deleteAllByRegex(String row, String colRegex, long ts) throws IOException {
        this.deleteAllByRegex(Bytes.toBytes(row), colRegex, ts);
    }

    public void deleteAllByRegex(byte[] row, String colRegex, long ts) throws IOException {
        this.deleteAllByRegex(row, colRegex, ts, null);
    }

    public void deleteAllByRegex(byte[] row, String colRegex, long ts, RowLock rl) throws IOException {
        throw new UnsupportedOperationException("TODO: Not yet implemented");
    }

    public void deleteFamily(String row, String family) throws IOException {
        this.deleteFamily(row, family, Long.MAX_VALUE);
    }

    public void deleteFamily(byte[] row, byte[] family) throws IOException {
        this.deleteFamily(row, family, Long.MAX_VALUE);
    }

    public void deleteFamily(String row, String family, long timestamp) throws IOException {
        this.deleteFamily(Bytes.toBytes(row), Bytes.toBytes(family), timestamp);
    }

    public void deleteFamily(byte[] row, byte[] family, long timestamp) throws IOException {
        this.deleteFamily(row, family, timestamp, null);
    }

    public void deleteFamily(byte[] row, byte[] family, long timestamp, RowLock rl) throws IOException {
        Delete d = new Delete(row, Long.MAX_VALUE, rl);
        d.deleteFamily(HTable.stripColon(family), timestamp);
        this.delete(d);
    }

    public void deleteFamilyByRegex(String row, String familyRegex) throws IOException {
        this.deleteFamilyByRegex(row, familyRegex, Long.MAX_VALUE);
    }

    public void deleteFamilyByRegex(byte[] row, String familyRegex) throws IOException {
        this.deleteFamilyByRegex(row, familyRegex, Long.MAX_VALUE);
    }

    public void deleteFamilyByRegex(String row, String familyRegex, long timestamp) throws IOException {
        this.deleteFamilyByRegex(Bytes.toBytes(row), familyRegex, timestamp);
    }

    public void deleteFamilyByRegex(byte[] row, String familyRegex, long timestamp) throws IOException {
        this.deleteFamilyByRegex(row, familyRegex, timestamp, null);
    }

    public void deleteFamilyByRegex(byte[] row, String familyRegex, long timestamp, RowLock r1) throws IOException {
        throw new UnsupportedOperationException("TODO: Not yet implemented");
    }

    public boolean exists(byte[] row) throws IOException {
        return this.exists(row, null, Long.MAX_VALUE, null);
    }

    public boolean exists(byte[] row, byte[] column) throws IOException {
        return this.exists(row, column, Long.MAX_VALUE, null);
    }

    public boolean exists(byte[] row, byte[] column, long timestamp) throws IOException {
        return this.exists(row, column, timestamp, null);
    }

    public boolean exists(byte[] row, byte[] column, long timestamp, RowLock rl) throws IOException {
        Get g = new Get(row, rl);
        g.addColumn(column);
        g.setTimeStamp(timestamp);
        return this.exists(g);
    }

    public synchronized void commit(BatchUpdate batchUpdate) throws IOException {
        this.commit(batchUpdate, null);
    }

    public synchronized void commit(BatchUpdate batchUpdate, RowLock rl) throws IOException {
        for (BatchOperation bo : batchUpdate) {
            if (!bo.isPut()) {
                throw new IOException("Only Puts in BU as of 0.20.0");
            }
            Put p = new Put(batchUpdate.getRow(), rl);
            p.add(bo.getColumn(), batchUpdate.getTimestamp(), bo.getValue());
            this.put(p);
        }
    }

    public synchronized void commit(List<BatchUpdate> batchUpdates) throws IOException {
        for (BatchUpdate bu : batchUpdates) {
            this.commit(bu);
        }
    }

    public synchronized boolean checkAndSave(BatchUpdate batchUpdate, HbaseMapWritable<byte[], byte[]> expectedValues, RowLock rl) throws IOException {
        throw new UnsupportedOperationException("Replaced by checkAndPut");
    }

    private static byte[] stripColon(byte[] n) {
        byte col = n[n.length - 1];
        if (col == 58) {
            byte[] res = new byte[n.length - 1];
            System.arraycopy(n, 0, res, 0, n.length - 1);
            return res;
        }
        return n;
    }

    protected class OldClientScanner
    implements Scanner {
        private final ClientScanner cs;

        OldClientScanner(ClientScanner cs) {
            this.cs = cs;
        }

        protected void initialize() throws IOException {
            this.cs.initialize();
        }

        @Override
        public void close() {
            this.cs.close();
        }

        @Override
        public RowResult next() throws IOException {
            Result r = this.cs.next();
            return r == null || r.isEmpty() ? null : r.getRowResult();
        }

        @Override
        public RowResult[] next(int nbRows) throws IOException {
            Result[] rr = this.cs.next(nbRows);
            if (rr == null || rr.length == 0) {
                return null;
            }
            RowResult[] results = new RowResult[rr.length];
            for (int i = 0; i < rr.length; ++i) {
                results[i] = rr[i].getRowResult();
            }
            return results;
        }

        @Override
        public Iterator<RowResult> iterator() {
            return new Iterator<RowResult>(){
                RowResult next = null;

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        try {
                            this.next = OldClientScanner.this.next();
                            return this.next != null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return true;
                }

                @Override
                public RowResult next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    RowResult temp = this.next;
                    this.next = null;
                    return temp;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    protected class ClientScanner
    implements ResultScanner {
        private final Log CLIENT_LOG = LogFactory.getLog(this.getClass());
        private Scan scan;
        private boolean closed = false;
        private HRegionInfo currentRegion = null;
        private ScannerCallable callable = null;
        private final LinkedList<Result> cache = new LinkedList();
        private final int caching;
        private long lastNext;
        private Result lastResult = null;

        protected ClientScanner(Scan scan) {
            if (this.CLIENT_LOG.isDebugEnabled()) {
                this.CLIENT_LOG.debug((Object)("Creating scanner over " + Bytes.toString(HTable.this.getTableName()) + " starting at key '" + Bytes.toStringBinary(scan.getStartRow()) + "'"));
            }
            this.scan = scan;
            this.lastNext = System.currentTimeMillis();
            this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : HTable.this.scannerCaching;
        }

        public void initialize() throws IOException {
            this.nextScanner(this.caching);
        }

        protected Scan getScan() {
            return this.scan;
        }

        protected long getTimestamp() {
            return this.lastNext;
        }

        private boolean nextScanner(int nbRows) throws IOException {
            if (this.callable != null) {
                this.callable.setClose();
                HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                this.callable = null;
            }
            byte[] localStartKey = null;
            if (this.currentRegion != null) {
                byte[] endKey;
                if (this.CLIENT_LOG.isDebugEnabled()) {
                    this.CLIENT_LOG.debug((Object)("Finished with region " + (Object)((Object)this.currentRegion)));
                }
                if ((endKey = this.currentRegion.getEndKey()) == null || Bytes.equals(endKey, HConstants.EMPTY_BYTE_ARRAY) || this.filterSaysStop(endKey)) {
                    this.close();
                    return false;
                }
                localStartKey = endKey;
            } else {
                localStartKey = this.scan.getStartRow();
            }
            if (this.CLIENT_LOG.isDebugEnabled()) {
                this.CLIENT_LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'"));
            }
            try {
                this.callable = this.getScannerCallable(localStartKey, nbRows);
                HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                this.currentRegion = this.callable.getHRegionInfo();
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
            return true;
        }

        protected ScannerCallable getScannerCallable(byte[] localStartKey, int nbRows) {
            this.scan.setStartRow(localStartKey);
            ScannerCallable s = new ScannerCallable(HTable.this.getConnection(), HTable.this.getTableName(), this.scan);
            s.setCaching(nbRows);
            return s;
        }

        private boolean filterSaysStop(byte[] endKey) {
            byte[] stopRow;
            int cmp;
            if (this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo(stopRow = this.scan.getStopRow(), 0, stopRow.length, endKey, 0, endKey.length)) <= 0) {
                return true;
            }
            if (!this.scan.hasFilter()) {
                return false;
            }
            if (this.scan.getFilter() != null) {
                this.scan.getFilter().filterRowKey(endKey, 0, endKey.length);
                return this.scan.getFilter().filterAllRemaining();
            }
            if (this.scan.getOldFilter() != null) {
                this.scan.getOldFilter().filterRowKey(endKey, 0, endKey.length);
                return this.scan.getOldFilter().filterAllRemaining();
            }
            return false;
        }

        @Override
        public Result next() throws IOException {
            if (this.cache.size() == 0 && this.closed) {
                return null;
            }
            if (this.cache.size() == 0) {
                Result[] values = null;
                int countdown = this.caching;
                this.callable.setCaching(this.caching);
                boolean skipFirst = false;
                do {
                    try {
                        values = HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                        if (skipFirst) {
                            skipFirst = false;
                            values = HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                        }
                    }
                    catch (DoNotRetryIOException e) {
                        Throwable cause = e.getCause();
                        if (cause == null || !(cause instanceof NotServingRegionException)) {
                            throw e;
                        }
                        this.scan.setStartRow(this.lastResult.getRow());
                        this.currentRegion = null;
                        skipFirst = true;
                        continue;
                    }
                    catch (IOException e) {
                        if (e instanceof UnknownScannerException && this.lastNext + (long)HTable.this.scannerTimeout < System.currentTimeMillis()) {
                            ScannerTimeoutException ex = new ScannerTimeoutException();
                            ex.initCause(e);
                            throw ex;
                        }
                        throw e;
                    }
                    this.lastNext = System.currentTimeMillis();
                    if (values == null || values.length <= 0) continue;
                    for (Result rs : values) {
                        this.cache.add(rs);
                        --countdown;
                        this.lastResult = rs;
                    }
                } while (countdown > 0 && this.nextScanner(countdown));
            }
            if (this.cache.size() > 0) {
                return this.cache.poll();
            }
            return null;
        }

        @Override
        public Result[] next(int nbRows) throws IOException {
            Result next;
            ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
            for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                resultSets.add(next);
            }
            return resultSets.toArray(new Result[resultSets.size()]);
        }

        @Override
        public void close() {
            if (this.callable != null) {
                this.callable.setClose();
                try {
                    HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.callable = null;
            }
            this.closed = true;
        }

        @Override
        public Iterator<Result> iterator() {
            return new Iterator<Result>(){
                Result next = null;

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        try {
                            this.next = ClientScanner.this.next();
                            return this.next != null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return true;
                }

                @Override
                public Result next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    Result temp = this.next;
                    this.next = null;
                    return temp;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

