/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;

public class HTablePool {
    private final Map<String, LinkedList<HTable>> tables = Collections.synchronizedMap(new HashMap());
    private final HBaseConfiguration config;
    private final int maxSize;

    public HTablePool() {
        this(new HBaseConfiguration(), Integer.MAX_VALUE);
    }

    public HTablePool(HBaseConfiguration config, int maxSize) {
        this.config = config;
        this.maxSize = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTable getTable(String tableName) {
        HTable table;
        LinkedList<HTable> queue = this.tables.get(tableName);
        if (queue == null) {
            queue = new LinkedList();
            this.tables.put(tableName, queue);
            return this.newHTable(tableName);
        }
        LinkedList<HTable> linkedList = queue;
        synchronized (linkedList) {
            table = queue.poll();
        }
        if (table == null) {
            return this.newHTable(tableName);
        }
        return table;
    }

    public HTable getTable(byte[] tableName) {
        return this.getTable(Bytes.toString(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTable(HTable table) {
        LinkedList<HTable> queue;
        LinkedList<HTable> linkedList = queue = this.tables.get(Bytes.toString(table.getTableName()));
        synchronized (linkedList) {
            if (queue.size() >= this.maxSize) {
                return;
            }
            queue.add(table);
        }
    }

    private HTable newHTable(String tableName) {
        try {
            return new HTable(this.config, Bytes.toBytes(tableName));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

