/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.util.Bytes;

class MetaScanner
implements HConstants {
    MetaScanner() {
    }

    public static void metaScan(HBaseConfiguration configuration, MetaScannerVisitor visitor) throws IOException {
        MetaScanner.metaScan(configuration, visitor, EMPTY_START_ROW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void metaScan(HBaseConfiguration configuration, MetaScannerVisitor visitor, byte[] tableName) throws IOException {
        HConnection connection = HConnectionManager.getConnection(configuration);
        byte[] startRow = tableName == null || tableName.length == 0 ? HConstants.EMPTY_START_ROW : HRegionInfo.createRegionName(tableName, null, "00000000000000");
        ScannerCallable callable = null;
        do {
            Scan scan = new Scan(startRow).addFamily(CATALOG_FAMILY);
            callable = new ScannerCallable(connection, META_TABLE_NAME, scan);
            connection.getRegionServerWithRetries(callable);
            try {
                Result[] rrs;
                Result r = null;
                while ((rrs = connection.getRegionServerWithRetries(callable)) != null && rrs.length != 0 && rrs[0].size() != 0 && visitor.processRow(r = rrs[0])) {
                }
                startRow = callable.getHRegionInfo().getEndKey();
            }
            finally {
                callable.setClose();
                connection.getRegionServerWithRetries(callable);
            }
        } while (Bytes.compareTo(startRow, LAST_ROW) != 0);
    }

    static interface MetaScannerVisitor {
        public boolean processRow(Result var1) throws IOException;
    }
}

