/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class Result
implements Writable {
    private KeyValue[] kvs = null;
    private NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> familyMap = null;
    private transient byte[] row = null;

    public Result() {
    }

    public Result(KeyValue[] kvs) {
        if (kvs != null && kvs.length > 0) {
            this.kvs = kvs;
        }
    }

    public Result(List<KeyValue> kvs) {
        this(kvs.toArray(new KeyValue[0]));
    }

    public synchronized byte[] getRow() {
        if (this.row == null) {
            this.row = this.kvs == null || this.kvs.length == 0 ? null : this.kvs[0].getRow();
        }
        return this.row;
    }

    public KeyValue[] raw() {
        return this.kvs;
    }

    public List<KeyValue> list() {
        return Arrays.asList(this.sorted());
    }

    public KeyValue[] sorted() {
        if (this.isEmpty()) {
            return null;
        }
        Arrays.sort(this.kvs, KeyValue.COMPARATOR);
        return this.kvs;
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getMap() {
        if (this.familyMap != null) {
            return this.familyMap;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.familyMap = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        for (KeyValue kv : this.kvs) {
            byte[] qualifier;
            TreeMap<Long, byte[]> versionMap;
            KeyValue.SplitKeyValue splitKV = kv.split();
            byte[] family = splitKV.getFamily();
            TreeMap columnMap = (TreeMap)this.familyMap.get(family);
            if (columnMap == null) {
                columnMap = new TreeMap(Bytes.BYTES_COMPARATOR);
                this.familyMap.put(family, columnMap);
            }
            if ((versionMap = (TreeMap<Long, byte[]>)columnMap.get(qualifier = splitKV.getQualifier())) == null) {
                versionMap = new TreeMap<Long, byte[]>(new Comparator<Long>(){

                    @Override
                    public int compare(Long l1, Long l2) {
                        return l2.compareTo(l1);
                    }
                });
                columnMap.put(qualifier, versionMap);
            }
            Long timestamp = Bytes.toLong(splitKV.getTimestamp());
            byte[] value = splitKV.getValue();
            versionMap.put(timestamp, value);
        }
        return this.familyMap;
    }

    public NavigableMap<byte[], NavigableMap<byte[], byte[]>> getNoVersionMap() {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], NavigableMap<byte[], byte[]>> returnMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyEntry : this.familyMap.entrySet()) {
            TreeMap<byte[], byte[]> qualifierMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
            for (Map.Entry qualifierEntry : ((NavigableMap)familyEntry.getValue()).entrySet()) {
                byte[] value = (byte[])((NavigableMap)qualifierEntry.getValue()).get(((NavigableMap)qualifierEntry.getValue()).firstKey());
                qualifierMap.put((byte[])qualifierEntry.getKey(), value);
            }
            returnMap.put((byte[])familyEntry.getKey(), (NavigableMap<byte[], byte[]>)qualifierMap);
        }
        return returnMap;
    }

    public NavigableMap<byte[], byte[]> getFamilyMap(byte[] family) {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], byte[]> returnMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        NavigableMap qualifierMap = (NavigableMap)this.familyMap.get(family);
        if (qualifierMap == null) {
            return returnMap;
        }
        for (Map.Entry entry : qualifierMap.entrySet()) {
            byte[] value = (byte[])((NavigableMap)entry.getValue()).get(((NavigableMap)entry.getValue()).firstKey());
            returnMap.put((byte[])entry.getKey(), value);
        }
        return returnMap;
    }

    public byte[] getValue(byte[] family, byte[] qualifier) {
        Map.Entry<Long, byte[]> entry = this.getKeyValue(family, qualifier);
        return entry == null ? null : entry.getValue();
    }

    public Cell getCellValue(byte[] family, byte[] qualifier) {
        Map.Entry<Long, byte[]> val = this.getKeyValue(family, qualifier);
        if (val == null) {
            return null;
        }
        return new Cell(val.getValue(), (long)val.getKey());
    }

    public Cell getCellValue() {
        return this.isEmpty() ? null : new Cell(this.kvs[0].getValue(), this.kvs[0].getTimestamp());
    }

    public Cell[] getCellValues() {
        if (this.isEmpty()) {
            return null;
        }
        Cell[] results = new Cell[this.kvs.length];
        for (int i = 0; i < this.kvs.length; ++i) {
            results[i] = new Cell(this.kvs[i].getValue(), this.kvs[i].getTimestamp());
        }
        return results;
    }

    private Map.Entry<Long, byte[]> getKeyValue(byte[] family, byte[] qualifier) {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        NavigableMap qualifierMap = (NavigableMap)this.familyMap.get(family);
        if (qualifierMap == null) {
            return null;
        }
        NavigableMap<Long, byte[]> versionMap = this.getVersionMap(qualifierMap, qualifier);
        if (versionMap == null) {
            return null;
        }
        return versionMap.firstEntry();
    }

    private NavigableMap<Long, byte[]> getVersionMap(NavigableMap<byte[], NavigableMap<Long, byte[]>> qualifierMap, byte[] qualifier) {
        return qualifier != null ? (NavigableMap)qualifierMap.get(qualifier) : (NavigableMap)qualifierMap.get(new byte[0]);
    }

    public byte[] getValue(byte[] column) {
        try {
            byte[][] split = KeyValue.parseColumn(column);
            return this.getValue(split[0], split[1]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean containsColumn(byte[] family, byte[] qualifier) {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return false;
        }
        NavigableMap qualifierMap = (NavigableMap)this.familyMap.get(family);
        if (qualifierMap == null) {
            return false;
        }
        NavigableMap<Long, byte[]> versionMap = this.getVersionMap(qualifierMap, qualifier);
        return versionMap != null;
    }

    public RowResult getRowResult() {
        return RowResult.createRowResult(Arrays.asList(this.kvs));
    }

    public byte[] value() {
        if (this.isEmpty()) {
            return null;
        }
        return this.kvs[0].getValue();
    }

    public boolean isEmpty() {
        return this.kvs == null || this.kvs.length == 0;
    }

    public int size() {
        return this.kvs == null ? 0 : this.kvs.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("keyvalues=");
        if (this.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (KeyValue kv : this.kvs) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.familyMap = null;
        this.row = null;
        int numKeys = in.readInt();
        this.kvs = new KeyValue[numKeys];
        if (numKeys == 0) {
            return;
        }
        int totalBuffer = in.readInt();
        byte[] buf = new byte[totalBuffer];
        int offset = 0;
        for (int i = 0; i < numKeys; ++i) {
            int keyLength = in.readInt();
            in.readFully(buf, offset, keyLength);
            this.kvs[i] = new KeyValue(buf, offset, keyLength);
            offset += keyLength;
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.isEmpty()) {
            out.writeInt(0);
        } else {
            int len = this.kvs.length;
            out.writeInt(len);
            int totalLen = 0;
            for (KeyValue kv : this.kvs) {
                totalLen += kv.getLength();
            }
            out.writeInt(totalLen);
            for (KeyValue kv : this.kvs) {
                out.writeInt(kv.getLength());
                out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
        }
    }

    public static void writeArray(DataOutput out, Result[] results) throws IOException {
        if (results == null || results.length == 0) {
            out.writeInt(0);
            return;
        }
        out.writeInt(results.length);
        int bufLen = 0;
        for (Result result : results) {
            if (result == null || result.isEmpty()) continue;
            for (KeyValue key : result.raw()) {
                bufLen += key.getLength();
            }
        }
        out.writeInt(bufLen);
        for (Result result : results) {
            if (result == null || result.isEmpty()) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(result.size());
            for (KeyValue kv : result.raw()) {
                out.writeInt(kv.getLength());
                out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
        }
    }

    public static Result[] readArray(DataInput in) throws IOException {
        int numResults = in.readInt();
        if (numResults == 0) {
            return new Result[0];
        }
        Result[] results = new Result[numResults];
        int bufSize = in.readInt();
        byte[] buf = new byte[bufSize];
        int offset = 0;
        for (int i = 0; i < numResults; ++i) {
            int numKeys = in.readInt();
            KeyValue[] keys = new KeyValue[numKeys];
            for (int j = 0; j < numKeys; ++j) {
                int keyLen = in.readInt();
                in.readFully(buf, offset, keyLen);
                keys[j] = new KeyValue(buf, offset, keyLen);
                offset += keyLen;
            }
            results[i] = new Result(keys);
        }
        return results;
    }
}

