/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;

public class RetriesExhaustedException
extends IOException {
    private static final long serialVersionUID = 1876775844L;

    public RetriesExhaustedException(String serverName, byte[] regionName, byte[] row, int numTries, List<Throwable> exceptions) {
        super(RetriesExhaustedException.getMessage(serverName, regionName, row, numTries, exceptions));
    }

    private static String getMessage(String serverName, byte[] regionName, byte[] row, int numTries, List<Throwable> exceptions) {
        StringBuilder buffer = new StringBuilder("Trying to contact region server ");
        buffer.append(serverName);
        buffer.append(" for region ");
        buffer.append(regionName == null ? "" : Bytes.toStringBinary(regionName));
        buffer.append(", row '");
        buffer.append(row == null ? "" : Bytes.toStringBinary(row));
        buffer.append("', but failed after ");
        buffer.append(numTries + 1);
        buffer.append(" attempts.\nExceptions:\n");
        for (Throwable t : exceptions) {
            buffer.append(t.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

