/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;

public class Scan
implements Writable {
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private byte[] stopRow = HConstants.EMPTY_END_ROW;
    private int maxVersions = 1;
    private int caching = -1;
    private Filter filter = null;
    private RowFilterInterface oldFilter = null;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Scan() {
    }

    public Scan(byte[] startRow, Filter filter) {
        this(startRow);
        this.filter = filter;
    }

    public Scan(byte[] startRow) {
        this.startRow = startRow;
    }

    public Scan(byte[] startRow, byte[] stopRow) {
        this.startRow = startRow;
        this.stopRow = stopRow;
    }

    public Scan(Scan scan) throws IOException {
        this.startRow = scan.getStartRow();
        this.stopRow = scan.getStopRow();
        this.maxVersions = scan.getMaxVersions();
        this.caching = scan.getCaching();
        this.filter = scan.getFilter();
        this.oldFilter = scan.getOldFilter();
        TimeRange ctr = scan.getTimeRange();
        this.tr = new TimeRange(ctr.getMin(), ctr.getMax());
        Map<byte[], NavigableSet<byte[]>> fams = scan.getFamilyMap();
        for (byte[] fam : fams.keySet()) {
            NavigableSet<byte[]> cols = fams.get(fam);
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
    }

    public Scan addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Scan addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Scan addColumn(byte[] familyAndQualifier) {
        byte[][] fq = KeyValue.parseColumn(familyAndQualifier);
        if (fq.length > 1 && fq[1] != null && fq[1].length > 0) {
            this.addColumn(fq[0], fq[1]);
        } else {
            this.addFamily(fq[0]);
        }
        return this;
    }

    public Scan addColumns(byte[][] columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.addColumn(columns[i]);
        }
        return this;
    }

    public Scan addColumns(String columns) {
        String[] cols;
        for (String col : cols = columns.split(" ")) {
            this.addColumn(Bytes.toBytes(col));
        }
        return this;
    }

    public String getInputColumns() {
        String cols = "";
        for (Map.Entry<byte[], NavigableSet<byte[]>> e : this.familyMap.entrySet()) {
            NavigableSet<byte[]> quals;
            byte[] fam = e.getKey();
            if (cols.length() > 0) {
                cols = cols + " ";
            }
            if ((quals = e.getValue()) != null && quals.size() > 0) {
                String cs = "";
                for (byte[] qual : quals) {
                    if (cs.length() > 0) {
                        cs = cs + " ";
                    }
                    cs = cs + Bytes.toStringBinary(fam) + ":" + Bytes.toStringBinary(qual);
                }
                cols = cols + cs;
                continue;
            }
            cols = cols + Bytes.toStringBinary(fam) + ":";
        }
        return cols;
    }

    public Scan setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Scan setTimeStamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Scan setStartRow(byte[] startRow) {
        this.startRow = startRow;
        return this;
    }

    public Scan setStopRow(byte[] stopRow) {
        this.stopRow = stopRow;
        return this;
    }

    public Scan setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Scan setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
        return this;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }

    public Scan setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Scan setOldFilter(RowFilterInterface filter) {
        this.oldFilter = filter;
        return this;
    }

    public Scan setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
        return this;
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public int numFamilies() {
        if (this.hasFamilies()) {
            return this.familyMap.size();
        }
        return 0;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public byte[][] getFamilies() {
        if (this.hasFamilies()) {
            return (byte[][])this.familyMap.keySet().toArray((T[])new byte[0][0]);
        }
        return null;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getCaching() {
        return this.caching;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public RowFilterInterface getOldFilter() {
        return this.oldFilter;
    }

    public boolean hasFilter() {
        return this.filter != null || this.oldFilter != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("startRow=");
        sb.append(Bytes.toString(this.startRow));
        sb.append(", stopRow=");
        sb.append(Bytes.toString(this.stopRow));
        sb.append(", maxVersions=");
        sb.append("" + this.maxVersions);
        sb.append(", caching=");
        sb.append("" + this.caching);
        sb.append(", timeRange=");
        sb.append("[" + this.tr.getMin() + "," + this.tr.getMax() + ")");
        sb.append(", families=");
        if (this.familyMap.size() == 0) {
            sb.append("ALL");
            return sb.toString();
        }
        boolean moreThanOne = false;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append("), ");
            } else {
                moreThanOne = true;
                sb.append("{");
            }
            sb.append("(family=");
            sb.append(Bytes.toString(entry.getKey()));
            sb.append(", columns=");
            if (entry.getValue() == null) {
                sb.append("ALL");
                continue;
            }
            sb.append("{");
            boolean moreThanOneB = false;
            for (byte[] column : entry.getValue()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(Bytes.toString(column));
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    private Writable createForName(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return WritableFactories.newInstance(clazz, (Configuration)new Configuration());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.startRow = Bytes.readByteArray(in);
        this.stopRow = Bytes.readByteArray(in);
        this.maxVersions = in.readInt();
        this.caching = in.readInt();
        if (in.readBoolean()) {
            this.filter = (Filter)this.createForName(Bytes.toString(Bytes.readByteArray(in)));
            this.filter.readFields(in);
        }
        if (in.readBoolean()) {
            this.oldFilter = (RowFilterInterface)this.createForName(Bytes.toString(Bytes.readByteArray(in)));
            this.oldFilter.readFields(in);
        }
        this.tr = new TimeRange();
        this.tr.readFields(in);
        int numFamilies = in.readInt();
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = in.readInt();
            TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (int j = 0; j < numColumns; ++j) {
                byte[] qualifier = Bytes.readByteArray(in);
                set.add(qualifier);
            }
            this.familyMap.put(family, set);
        }
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.startRow);
        Bytes.writeByteArray(out, this.stopRow);
        out.writeInt(this.maxVersions);
        out.writeInt(this.caching);
        if (this.filter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, Bytes.toBytes(this.filter.getClass().getName()));
            this.filter.write(out);
        }
        if (this.oldFilter == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Bytes.writeByteArray(out, Bytes.toBytes(this.oldFilter.getClass().getName()));
            this.oldFilter.write(out);
        }
        this.tr.write(out);
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet != null) {
                out.writeInt(columnSet.size());
                for (byte[] qualifier : columnSet) {
                    Bytes.writeByteArray(out, qualifier);
                }
                continue;
            }
            out.writeInt(0);
        }
    }
}

