/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.ipc.RemoteException;
import org.mortbay.log.Log;

public class ScannerCallable
extends ServerCallable<Result[]> {
    private long scannerId = -1L;
    private boolean instantiated = false;
    private boolean closed = false;
    private Scan scan;
    private int caching = 1;

    public ScannerCallable(HConnection connection, byte[] tableName, Scan scan) {
        super(connection, tableName, scan.getStartRow());
        this.scan = scan;
    }

    @Override
    public void instantiateServer(boolean reload) throws IOException {
        if (!this.instantiated || reload) {
            super.instantiateServer(reload);
            this.instantiated = true;
        }
    }

    @Override
    public Result[] call() throws IOException {
        if (this.scannerId != -1L && this.closed) {
            this.close();
        } else if (this.scannerId == -1L && !this.closed) {
            this.scannerId = this.openScanner();
        } else {
            Result[] rrs;
            block7: {
                rrs = null;
                try {
                    rrs = this.server.next(this.scannerId, this.caching);
                }
                catch (IOException e) {
                    IOException ioe = null;
                    if (e instanceof RemoteException) {
                        ioe = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                    }
                    if (ioe == null || !(ioe instanceof NotServingRegionException)) break block7;
                    throw new DoNotRetryIOException("Reset scanner", ioe);
                }
            }
            return rrs == null || rrs.length == 0 ? null : rrs;
        }
        return null;
    }

    private void close() {
        if (this.scannerId == -1L) {
            return;
        }
        try {
            this.server.close(this.scannerId);
        }
        catch (IOException e) {
            Log.warn((String)"Ignore, probably already closed", (Throwable)e);
        }
        this.scannerId = -1L;
    }

    protected long openScanner() throws IOException {
        return this.server.openScanner(this.location.getRegionInfo().getRegionName(), this.scan);
    }

    protected Scan getScan() {
        return this.scan;
    }

    public void setClose() {
        this.closed = true;
    }

    public HRegionInfo getHRegionInfo() {
        if (!this.instantiated) {
            return null;
        }
        return this.location.getRegionInfo();
    }

    public int getCaching() {
        return this.caching;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }
}

