/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.io.Writable;

public class FilterList
implements Filter {
    private Operator operator = Operator.MUST_PASS_ALL;
    private List<Filter> filters = new ArrayList<Filter>();

    public FilterList() {
    }

    public FilterList(List<Filter> rowFilters) {
        this.filters = rowFilters;
    }

    public FilterList(Operator operator, List<Filter> rowFilters) {
        this.filters = rowFilters;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public void reset() {
        for (Filter filter : this.filters) {
            filter.reset();
        }
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public boolean filterAllRemaining() {
        for (Filter filter : this.filters) {
            if (filter.filterAllRemaining()) {
                if (this.operator != Operator.MUST_PASS_ALL) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        block8: for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (filter.filterAllRemaining()) {
                    return Filter.ReturnCode.NEXT_ROW;
                }
                switch (filter.filterKeyValue(v)) {
                    case INCLUDE: {
                        continue block8;
                    }
                    case NEXT_ROW: 
                    case SKIP: {
                        return Filter.ReturnCode.SKIP;
                    }
                }
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining()) continue;
            switch (filter.filterKeyValue(v)) {
                case INCLUDE: {
                    return Filter.ReturnCode.INCLUDE;
                }
                case NEXT_ROW: 
                case SKIP: {
                    continue block8;
                }
            }
        }
        return this.operator == Operator.MUST_PASS_ONE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRow() {
        for (Filter filter : this.filters) {
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRow()) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRow()) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    public void readFields(DataInput in) throws IOException {
        HBaseConfiguration conf = new HBaseConfiguration();
        byte opByte = in.readByte();
        this.operator = Operator.values()[opByte];
        int size = in.readInt();
        if (size > 0) {
            this.filters = new ArrayList<Filter>(size);
            for (int i = 0; i < size; ++i) {
                Filter filter = (Filter)HbaseObjectWritable.readObject(in, conf);
                this.filters.add(filter);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        HBaseConfiguration conf = new HBaseConfiguration();
        out.writeByte(this.operator.ordinal());
        out.writeInt(this.filters.size());
        for (Filter filter : this.filters) {
            HbaseObjectWritable.writeObject(out, filter, Writable.class, conf);
        }
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

