/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;

public class InclusiveStopFilter
implements Filter {
    private byte[] stopRowKey;

    public InclusiveStopFilter() {
    }

    public InclusiveStopFilter(byte[] stopRowKey) {
        this.stopRowKey = stopRowKey;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return this.stopRowKey == null;
        }
        return Bytes.compareTo(this.stopRowKey, 0, this.stopRowKey.length, buffer, offset, length) < 0;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRow() {
        return false;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.stopRowKey);
    }

    public void readFields(DataInput in) throws IOException {
        this.stopRowKey = Bytes.readByteArray(in);
    }
}

