/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;

public class PrefixFilter
implements Filter {
    protected byte[] prefix = null;

    public PrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public PrefixFilter() {
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null || this.prefix == null) {
            return true;
        }
        if (length < this.prefix.length) {
            return true;
        }
        return Bytes.compareTo(buffer, offset, this.prefix.length, this.prefix, 0, this.prefix.length) != 0;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRow() {
        return false;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.prefix);
    }

    public void readFields(DataInput in) throws IOException {
        this.prefix = Bytes.readByteArray(in);
    }
}

