/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class RegexStringComparator
implements WritableByteArrayComparable {
    private Pattern pattern;

    public RegexStringComparator() {
    }

    public RegexStringComparator(String expr) {
        this.pattern = Pattern.compile(expr);
    }

    @Override
    public int compareTo(byte[] value) {
        return this.pattern.matcher(Bytes.toString(value)).find() ? 0 : 1;
    }

    public void readFields(DataInput in) throws IOException {
        this.pattern = Pattern.compile(in.readUTF());
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.pattern.toString());
    }
}

