/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.ObjectWritable;

public class ValueFilter
implements Filter {
    static final Log LOG = LogFactory.getLog(ValueFilter.class);
    private byte[] columnFamily;
    private byte[] columnQualifier;
    private CompareOp compareOp;
    private byte[] value;
    private WritableByteArrayComparable comparator;
    private boolean filterIfColumnMissing;
    private boolean filterThisRow = false;
    private boolean foundColValue = false;

    ValueFilter() {
    }

    public ValueFilter(byte[] family, byte[] qualifier, CompareOp compareOp, byte[] value) {
        this(family, qualifier, compareOp, value, true);
    }

    public ValueFilter(byte[] family, byte[] qualifier, CompareOp compareOp, byte[] value, boolean filterIfColumnMissing) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.compareOp = compareOp;
        this.value = value;
        this.filterIfColumnMissing = filterIfColumnMissing;
    }

    public ValueFilter(byte[] family, byte[] qualifier, CompareOp compareOp, WritableByteArrayComparable comparator) {
        this(family, qualifier, compareOp, comparator, true);
    }

    public ValueFilter(byte[] family, byte[] qualifier, CompareOp compareOp, WritableByteArrayComparable comparator, boolean filterIfColumnMissing) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.compareOp = compareOp;
        this.comparator = comparator;
        this.filterIfColumnMissing = filterIfColumnMissing;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue keyValue) {
        if (!keyValue.matchingColumn(this.columnFamily, this.columnQualifier)) {
            return Filter.ReturnCode.INCLUDE;
        }
        this.foundColValue = true;
        boolean filtered = this.filterColumnValue(keyValue.getBuffer(), keyValue.getValueOffset(), keyValue.getValueLength());
        if (filtered) {
            this.filterThisRow = true;
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    private boolean filterColumnValue(byte[] data, int offset, int length) {
        int compareResult = this.comparator != null ? this.comparator.compareTo(Arrays.copyOfRange(data, offset, offset + length)) : Bytes.compareTo(this.value, 0, this.value.length, data, offset, length);
        switch (this.compareOp) {
            case LESS: {
                return compareResult <= 0;
            }
            case LESS_OR_EQUAL: {
                return compareResult < 0;
            }
            case EQUAL: {
                return compareResult != 0;
            }
            case NOT_EQUAL: {
                return compareResult == 0;
            }
            case GREATER_OR_EQUAL: {
                return compareResult > 0;
            }
            case GREATER: {
                return compareResult >= 0;
            }
        }
        throw new RuntimeException("Unknown Compare op " + this.compareOp.name());
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public boolean filterRow() {
        return this.filterThisRow || this.filterIfColumnMissing && !this.foundColValue;
    }

    @Override
    public void reset() {
        this.filterThisRow = false;
        this.foundColValue = false;
    }

    public void readFields(DataInput in) throws IOException {
        int valueLen = in.readInt();
        if (valueLen > 0) {
            this.value = new byte[valueLen];
            in.readFully(this.value);
        }
        this.columnFamily = Bytes.readByteArray(in);
        this.columnQualifier = Bytes.readByteArray(in);
        this.compareOp = CompareOp.valueOf(in.readUTF());
        this.comparator = (WritableByteArrayComparable)ObjectWritable.readObject((DataInput)in, (Configuration)new HBaseConfiguration());
        this.filterIfColumnMissing = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        if (this.value == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.value.length);
            out.write(this.value);
        }
        Bytes.writeByteArray(out, this.columnFamily);
        Bytes.writeByteArray(out, this.columnQualifier);
        out.writeUTF(this.compareOp.name());
        ObjectWritable.writeObject((DataOutput)out, (Object)this.comparator, WritableByteArrayComparable.class, (Configuration)new HBaseConfiguration());
        out.writeBoolean(this.filterIfColumnMissing);
    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER;

    }
}

