/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import agilejson.TOJSON;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.rest.descriptors.RestCell;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class RowResult
implements Writable,
SortedMap<byte[], Cell>,
Comparable<RowResult>,
ISerializable {
    private byte[] row = null;
    private final HbaseMapWritable<byte[], Cell> cells;
    private final byte[] COL_REGIONINFO = Bytes.toBytes("info:regioninfo");

    public RowResult() {
        this(null, new HbaseMapWritable<byte[], Cell>());
    }

    public RowResult(byte[] row, HbaseMapWritable<byte[], Cell> m) {
        this.row = row;
        this.cells = m;
    }

    @TOJSON(base64=true)
    public byte[] getRow() {
        return this.row;
    }

    @Override
    public Cell put(byte[] key, Cell value) {
        throw new UnsupportedOperationException("RowResult is read-only!");
    }

    @Override
    public void putAll(Map map) {
        throw new UnsupportedOperationException("RowResult is read-only!");
    }

    @Override
    public Cell get(Object key) {
        return this.cells.get(key);
    }

    @Override
    public Cell remove(Object key) {
        throw new UnsupportedOperationException("RowResult is read-only!");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cells.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this.cells.containsKey(Bytes.toBytes(key));
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Don't support containsValue!");
    }

    @Override
    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    @Override
    public int size() {
        return this.cells.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("RowResult is read-only!");
    }

    @Override
    public Set<byte[]> keySet() {
        TreeSet<byte[]> result = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (byte[] w : this.cells.keySet()) {
            result.add(w);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<byte[], Cell>> entrySet() {
        return Collections.unmodifiableSet(this.cells.entrySet());
    }

    @TOJSON
    public RestCell[] getCells() {
        RestCell[] restCells = new RestCell[this.cells.size()];
        int i = 0;
        for (Map.Entry<byte[], Cell> entry : this.cells.entrySet()) {
            restCells[i] = new RestCell(entry.getKey(), entry.getValue());
            ++i;
        }
        return restCells;
    }

    @Override
    public Collection<Cell> values() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (Cell w : this.cells.values()) {
            result.add(w);
        }
        return result;
    }

    public Cell get(byte[] column) {
        return this.cells.get(column);
    }

    public Cell get(String key) {
        return this.get(Bytes.toBytes(key));
    }

    public Cell get(byte[] family, byte[] columnQualifier) {
        return this.get(Bytes.add(family, KeyValue.COLUMN_FAMILY_DELIM_ARRAY, columnQualifier));
    }

    @Override
    public Comparator<? super byte[]> comparator() {
        return this.cells.comparator();
    }

    @Override
    public byte[] firstKey() {
        return this.cells.firstKey();
    }

    @Override
    public SortedMap<byte[], Cell> headMap(byte[] toKey) {
        return this.cells.headMap(toKey);
    }

    @Override
    public byte[] lastKey() {
        return this.cells.lastKey();
    }

    @Override
    public SortedMap<byte[], Cell> subMap(byte[] fromKey, byte[] toKey) {
        return this.cells.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<byte[], Cell> tailMap(byte[] fromKey) {
        return this.cells.tailMap(fromKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row=");
        sb.append(Bytes.toString(this.row));
        sb.append(", cells={");
        boolean moreThanOne = false;
        for (Map.Entry<byte[], Cell> e : this.cells.entrySet()) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append("(column=");
            sb.append(Bytes.toString(e.getKey()));
            sb.append(", timestamp=");
            sb.append(Long.toString(e.getValue().getTimestamp()));
            sb.append(", value=");
            byte[] v = e.getValue().getValue();
            if (Bytes.equals(e.getKey(), this.COL_REGIONINFO)) {
                try {
                    sb.append(Writables.getHRegionInfo(v).toString());
                }
                catch (IOException ioe) {
                    sb.append(ioe.toString());
                }
            } else {
                sb.append(v);
            }
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
        serializer.serializeRowResult(this);
    }

    public static RowResult[] createRowResultArray(List<List<KeyValue>> l) {
        RowResult[] results = new RowResult[l.size()];
        int i = 0;
        for (List<KeyValue> kvl : l) {
            results[i++] = RowResult.createRowResult(kvl);
        }
        return results;
    }

    public static RowResult createRowResult(List<KeyValue> results) {
        if (results.isEmpty()) {
            return null;
        }
        HbaseMapWritable<byte[], Cell> cells = Cell.createCells(results);
        byte[] row = results.get(0).getRow();
        return new RowResult(row, cells);
    }

    public void readFields(DataInput in) throws IOException {
        this.row = Bytes.readByteArray(in);
        this.cells.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.row);
        this.cells.write(out);
    }

    @Override
    public int compareTo(RowResult o) {
        return Bytes.compareTo(this.row, o.getRow());
    }

    public class Entry
    implements Map.Entry<byte[], Cell> {
        private final byte[] column;
        private final Cell cell;

        Entry(byte[] row, Cell cell) {
            this.column = row;
            this.cell = cell;
        }

        @Override
        public Cell setValue(Cell c) {
            throw new UnsupportedOperationException("RowResult is read-only!");
        }

        @Override
        public byte[] getKey() {
            return this.column;
        }

        @Override
        public Cell getValue() {
            return this.cell;
        }
    }
}

