/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IndexConfiguration;
import org.apache.hadoop.hbase.mapreduce.LuceneDocumentWrapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;

public class IndexRecordWriter
extends RecordWriter<ImmutableBytesWritable, LuceneDocumentWrapper> {
    static final Log LOG = LogFactory.getLog(IndexRecordWriter.class);
    private long docCount = 0L;
    private TaskAttemptContext context = null;
    private FileSystem fs = null;
    private IndexWriter writer = null;
    private IndexConfiguration indexConf = null;
    private Path perm = null;
    private Path temp = null;

    public IndexRecordWriter(TaskAttemptContext context, FileSystem fs, IndexWriter writer, IndexConfiguration indexConf, Path perm, Path temp) {
        this.context = context;
        this.fs = fs;
        this.writer = writer;
        this.indexConf = indexConf;
        this.perm = perm;
        this.temp = temp;
    }

    public void write(ImmutableBytesWritable key, LuceneDocumentWrapper value) throws IOException {
        Document doc = value.get();
        this.writer.addDocument(doc);
        ++this.docCount;
        this.context.progress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(TaskAttemptContext context) throws IOException {
        HeartbeatsThread prog = new HeartbeatsThread();
        try {
            prog.start();
            if (this.indexConf.doOptimize()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Optimizing index.");
                }
                this.writer.optimize();
            }
            this.writer.close();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Done indexing " + this.docCount + " docs."));
            }
            this.fs.completeLocalOutput(this.perm, this.temp);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Copy done.");
            }
        }
        finally {
            prog.setClosed();
        }
    }

    class HeartbeatsThread
    extends Thread {
        private boolean closed = false;

        HeartbeatsThread() {
        }

        @Override
        public void run() {
            while (!this.closed) {
                try {
                    IndexRecordWriter.this.context.setStatus("closing");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                }
                catch (Throwable e) {
                    return;
                }
            }
        }

        public void setClosed() {
            this.closed = true;
        }
    }
}

