/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class RowCounter {
    static final String NAME = "rowcounter";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        Job job = new Job(conf, NAME);
        job.setJarByClass(RowCounter.class);
        StringBuilder sb = new StringBuilder();
        int columnoffset = 2;
        for (int i = 2; i < args.length; ++i) {
            if (i > 2) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        Scan scan = new Scan();
        scan.addColumns(sb.toString());
        TableMapReduceUtil.initTableMapperJob(args[1], scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[0]));
        return job;
    }

    public static void main(String[] args) throws Exception {
        Job job;
        HBaseConfiguration conf = new HBaseConfiguration();
        String[] otherArgs = new GenericOptionsParser((Configuration)conf, args).getRemainingArgs();
        if (otherArgs.length < 3) {
            System.err.println("ERROR: Wrong number of parameters: " + args.length);
            System.err.println("Usage: rowcounter <outputdir> <tablename> <column1> [<column2>...]");
            System.exit(-1);
        }
        System.exit((job = RowCounter.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }

    static class RowCounterMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            for (KeyValue value : values.list()) {
                if (value.getValue().length <= 0) continue;
                context.getCounter((Enum)Counters.ROWS).increment(1L);
                break;
            }
        }

        private static enum Counters {
            ROWS;

        }
    }
}

