/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.util.StringUtils;

public class TableInputFormat
extends TableInputFormatBase
implements Configurable {
    private final Log LOG = LogFactory.getLog(TableInputFormat.class);
    public static final String INPUT_TABLE = "hbase.mapreduce.inputtable";
    public static final String SCAN = "hbase.mapreduce.scan";
    private Configuration conf = null;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        String tableName = this.conf.get(INPUT_TABLE);
        try {
            this.setHTable(new HTable(new HBaseConfiguration(this.conf), tableName));
        }
        catch (Exception e) {
            this.LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
        Scan scan = null;
        try {
            scan = TableMapReduceUtil.convertStringToScan(this.conf.get(SCAN));
        }
        catch (IOException e) {
            this.LOG.error((Object)"An error occurred.", (Throwable)e);
        }
        this.setScan(scan);
    }
}

