/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.StringUtils;

public abstract class TableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    final Log LOG = LogFactory.getLog(TableInputFormatBase.class);
    private Scan scan = null;
    private HTable table = null;
    private TableRecordReader tableRecordReader = null;

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        TableSplit tSplit = (TableSplit)split;
        TableRecordReader trr = this.tableRecordReader;
        if (trr == null) {
            trr = new TableRecordReader();
        }
        Scan sc = new Scan(this.scan);
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        trr.setScan(sc);
        trr.setHTable(this.table);
        trr.init();
        return trr;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        byte[][] startKeys = this.table.getStartKeys();
        if (startKeys == null || startKeys.length == 0) {
            throw new IOException("Expecting at least one region.");
        }
        if (this.table == null) {
            throw new IOException("No table was provided.");
        }
        if (!this.scan.hasFamilies()) {
            throw new IOException("Expecting at least one column.");
        }
        int realNumSplits = startKeys.length;
        InputSplit[] splits = new InputSplit[realNumSplits];
        int middle = startKeys.length / realNumSplits;
        int startPos = 0;
        for (int i = 0; i < realNumSplits; ++i) {
            int lastPos = startPos + middle;
            lastPos = startKeys.length % realNumSplits > i ? lastPos + 1 : lastPos;
            String regionLocation = this.table.getRegionLocation(startKeys[startPos]).getServerAddress().getHostname();
            splits[i] = new TableSplit(this.table.getTableName(), startKeys[startPos], i + 1 < realNumSplits ? startKeys[lastPos] : HConstants.EMPTY_START_ROW, regionLocation);
            this.LOG.info((Object)("split: " + i + "->" + splits[i]));
            startPos = lastPos;
        }
        return Arrays.asList(splits);
    }

    protected HTable getHTable() {
        return this.table;
    }

    protected void setHTable(HTable table) {
        this.table = table;
    }

    public Scan getScan() {
        if (this.scan == null) {
            this.scan = new Scan();
        }
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    protected class TableRecordReader
    extends RecordReader<ImmutableBytesWritable, Result> {
        private ResultScanner scanner = null;
        private Scan scan = null;
        private HTable htable = null;
        private byte[] lastRow = null;
        private ImmutableBytesWritable key = null;
        private Result value = null;

        protected TableRecordReader() {
        }

        public void restart(byte[] firstRow) throws IOException {
            Scan newScan = new Scan(this.scan);
            newScan.setStartRow(firstRow);
            this.scanner = this.htable.getScanner(newScan);
        }

        public void init() throws IOException {
            this.restart(this.scan.getStartRow());
        }

        public void setHTable(HTable htable) {
            this.htable = htable;
        }

        public void setScan(Scan scan) {
            this.scan = scan;
        }

        public void close() {
            this.scanner.close();
        }

        public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
            return this.key;
        }

        public Result getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.key == null) {
                this.key = new ImmutableBytesWritable();
            }
            if (this.value == null) {
                this.value = new Result();
            }
            try {
                this.value = this.scanner.next();
            }
            catch (IOException e) {
                TableInputFormatBase.this.LOG.debug((Object)("recovered from " + StringUtils.stringifyException((Throwable)e)));
                this.restart(this.lastRow);
                this.scanner.next();
                this.value = this.scanner.next();
            }
            if (this.value != null && this.value.size() > 0) {
                this.key.set(this.value.getRow());
                this.lastRow = this.key.get();
                return true;
            }
            return false;
        }

        public float getProgress() {
            return 0.0f;
        }
    }
}

