/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.RegionManager;
import org.apache.hadoop.hbase.master.TableOperation;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

class ChangeTableState
extends TableOperation {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private boolean online;
    protected final Map<String, HashSet<HRegionInfo>> servedRegions = new HashMap<String, HashSet<HRegionInfo>>();
    protected long lockid;

    ChangeTableState(HMaster master, byte[] tableName, boolean onLine) throws IOException {
        super(master, tableName);
        this.online = onLine;
    }

    @Override
    protected void processScanItem(String serverName, HRegionInfo info) {
        if (this.isBeingServed(serverName)) {
            HashSet<HRegionInfo> regions = this.servedRegions.get(serverName);
            if (regions == null) {
                regions = new HashSet();
            }
            regions.add(info);
            this.servedRegions.put(serverName, regions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postProcessMeta(MetaRegion m, HRegionInterface server) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"processing unserved regions");
        }
        for (HRegionInfo i : this.unservedRegions) {
            if (i.isOffline() && i.isSplit()) {
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug((Object)("Skipping region " + i.toString() + " because it is offline because it has been split"));
                continue;
            }
            Put put = this.updateRegionInfo(i);
            server.put(m.getRegionName(), put);
            Delete delete = new Delete(i.getRegionName());
            delete.deleteColumns(CATALOG_FAMILY, SERVER_QUALIFIER);
            delete.deleteColumns(CATALOG_FAMILY, STARTCODE_QUALIFIER);
            server.delete(m.getRegionName(), delete);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Updated columns in row: " + i.getRegionNameAsString()));
            }
            RegionManager regionManager = this.master.regionManager;
            synchronized (regionManager) {
                if (this.online) {
                    if (!this.master.regionManager.regionIsOpening(i.getRegionNameAsString())) {
                        this.master.regionManager.setUnassigned(i, false);
                    }
                } else {
                    this.master.regionManager.removeRegion(i);
                }
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"processing regions currently being served");
        }
        RegionManager regionManager = this.master.regionManager;
        synchronized (regionManager) {
            for (Map.Entry<String, HashSet<HRegionInfo>> e : this.servedRegions.entrySet()) {
                String serverName = e.getKey();
                if (this.online) {
                    this.LOG.debug((Object)"Already online");
                    continue;
                }
                for (HRegionInfo i : e.getValue()) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("adding region " + i.getRegionNameAsString() + " to kill list"));
                    }
                    this.master.regionManager.setClosing(serverName, i, true);
                }
            }
        }
        this.servedRegions.clear();
    }

    protected Put updateRegionInfo(HRegionInfo i) throws IOException {
        i.setOffline(!this.online);
        Put put = new Put(i.getRegionName());
        put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)i));
        return put;
    }
}

