/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.util.Bytes;

public class MetaRegion
implements Comparable<MetaRegion> {
    private final HServerAddress server;
    private HRegionInfo regionInfo;

    MetaRegion(HServerAddress server, HRegionInfo regionInfo) {
        if (server == null) {
            throw new IllegalArgumentException("server cannot be null");
        }
        this.server = server;
        if (regionInfo == null) {
            throw new IllegalArgumentException("regionInfo cannot be null");
        }
        this.regionInfo = regionInfo;
    }

    public String toString() {
        return "{server: " + this.server.toString() + ", regionname: " + this.regionInfo.getRegionNameAsString() + ", startKey: <" + Bytes.toString(this.regionInfo.getStartKey()) + ">}";
    }

    public byte[] getRegionName() {
        return this.regionInfo.getRegionName();
    }

    public HServerAddress getServer() {
        return this.server;
    }

    public byte[] getStartKey() {
        return this.regionInfo.getStartKey();
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public boolean equals(Object o) {
        return o instanceof MetaRegion && this.compareTo((MetaRegion)o) == 0;
    }

    public int hashCode() {
        return this.regionInfo.hashCode();
    }

    @Override
    public int compareTo(MetaRegion other) {
        int cmp = this.regionInfo.compareTo(other.regionInfo);
        if (cmp == 0) {
            cmp = this.server.compareTo(other.server);
        }
        return cmp;
    }
}

