/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.ProcessRegionStatusChange;
import org.apache.hadoop.hbase.master.RetryableMetaOperation;
import org.apache.hadoop.hbase.regionserver.HRegion;

class ProcessRegionClose
extends ProcessRegionStatusChange {
    protected final boolean offlineRegion;
    protected final boolean reassignRegion;

    public ProcessRegionClose(HMaster master, HRegionInfo regionInfo, boolean offlineRegion, boolean reassignRegion) {
        super(master, regionInfo);
        this.offlineRegion = offlineRegion;
        this.reassignRegion = reassignRegion;
    }

    public String toString() {
        return "ProcessRegionClose of " + this.regionInfo.getRegionNameAsString() + ", " + this.offlineRegion + ", reassign: " + this.reassignRegion;
    }

    @Override
    protected boolean process() throws IOException {
        Boolean result = null;
        if (this.offlineRegion) {
            result = (Boolean)new RetryableMetaOperation<Boolean>(this.getMetaRegion(), this.master){

                @Override
                public Boolean call() throws IOException {
                    this.LOG.info((Object)("region closed: " + ProcessRegionClose.this.regionInfo.getRegionNameAsString()));
                    if (ProcessRegionClose.this.metaRegionAvailable()) {
                        HRegion.offlineRegionInMETA(this.server, ProcessRegionClose.this.metaRegionName, ProcessRegionClose.this.regionInfo);
                        this.master.regionManager.removeRegion(ProcessRegionClose.this.regionInfo);
                    }
                    return true;
                }
            }.doWithRetries();
            result = result == null ? true : result;
        } else if (this.reassignRegion) {
            LOG.info((Object)("region set as unassigned: " + this.regionInfo.getRegionNameAsString()));
            this.master.regionManager.setUnassigned(this.regionInfo, false);
        } else {
            LOG.info((Object)("Region was neither offlined, or asked to be reassigned, what gives: " + this.regionInfo.getRegionNameAsString()));
        }
        return result == null ? true : result;
    }
}

