/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.RegionHistorian;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.ProcessRegionStatusChange;
import org.apache.hadoop.hbase.master.RegionManager;
import org.apache.hadoop.hbase.util.Bytes;

class ProcessRegionOpen
extends ProcessRegionStatusChange {
    protected final HServerInfo serverInfo;

    public ProcessRegionOpen(HMaster master, HServerInfo info, HRegionInfo regionInfo) {
        super(master, regionInfo);
        if (info == null) {
            throw new NullPointerException("HServerInfo cannot be null; hbase-958 debugging");
        }
        this.serverInfo = info;
    }

    public String toString() {
        return "PendingOpenOperation from " + HServerInfo.getServerName(this.serverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean process() throws IOException {
        if (!this.metaRegionAvailable()) {
            return true;
        }
        RegionHistorian historian = RegionHistorian.getInstance();
        HRegionInterface server = this.master.connection.getHRegionConnection(this.getMetaRegion().getServer());
        LOG.info((Object)(this.regionInfo.getRegionNameAsString() + " open on " + this.serverInfo.getServerAddress().toString()));
        Put p = new Put(this.regionInfo.getRegionName());
        p.add(CATALOG_FAMILY, SERVER_QUALIFIER, Bytes.toBytes(this.serverInfo.getServerAddress().toString()));
        p.add(CATALOG_FAMILY, STARTCODE_QUALIFIER, Bytes.toBytes(this.serverInfo.getStartCode()));
        server.put(this.metaRegionName, p);
        LOG.info((Object)("Updated row " + this.regionInfo.getRegionNameAsString() + " in region " + Bytes.toString(this.metaRegionName) + " with startcode=" + this.serverInfo.getStartCode() + ", server=" + this.serverInfo.getServerAddress()));
        if (!historian.isOnline()) {
            historian.online(this.master.getConfiguration());
        }
        historian.addRegionOpen(this.regionInfo, this.serverInfo.getServerAddress());
        RegionManager regionManager = this.master.regionManager;
        synchronized (regionManager) {
            if (this.isMetaTable) {
                MetaRegion m = new MetaRegion(new HServerAddress(this.serverInfo.getServerAddress()), this.regionInfo);
                if (!this.master.regionManager.isInitialMetaScanComplete()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding " + m.toString() + " to regions to scan"));
                    }
                    this.master.regionManager.addMetaRegionToScan(m);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding to onlineMetaRegions: " + m.toString()));
                    }
                    this.master.regionManager.putMetaRegionOnline(m);
                    this.master.regionManager.metaScannerThread.interrupt();
                }
            }
            this.master.regionManager.removeRegion(this.regionInfo);
            return true;
        }
    }

    @Override
    protected int getPriority() {
        return 0;
    }
}

