/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.RegionManager;
import org.apache.hadoop.hbase.master.RegionServerOperation;
import org.apache.hadoop.hbase.master.RetryableMetaOperation;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

class ProcessServerShutdown
extends RegionServerOperation {
    private final String deadServer;
    private boolean isRootServer;
    private List<MetaRegion> metaRegions;
    private Path oldLogDir;
    private boolean logSplit;
    private boolean rootRescanned;
    private HServerAddress deadServerAddress;

    public ProcessServerShutdown(HMaster master, HServerInfo serverInfo) {
        super(master);
        this.deadServer = HServerInfo.getServerName(serverInfo);
        this.deadServerAddress = serverInfo.getServerAddress();
        this.logSplit = false;
        this.rootRescanned = false;
        this.oldLogDir = new Path(master.rootdir, HLog.getHLogDirectoryName(serverInfo));
        this.closeMetaRegions();
    }

    private void closeMetaRegions() {
        this.isRootServer = this.master.regionManager.isRootServer(this.deadServerAddress);
        if (this.isRootServer) {
            this.master.regionManager.unsetRootRegion();
        }
        List<byte[]> metaStarts = this.master.regionManager.listMetaRegionsForServer(this.deadServerAddress);
        this.metaRegions = new ArrayList<MetaRegion>();
        for (byte[] region : metaStarts) {
            MetaRegion r = this.master.regionManager.offlineMetaRegion(region);
            this.metaRegions.add(r);
        }
    }

    public String toString() {
        return "ProcessServerShutdown of " + this.deadServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scanMetaRegion(HRegionInterface server, long scannerId, byte[] regionName) throws IOException {
        ArrayList<ToDoEntry> toDoList = new ArrayList<ToDoEntry>();
        HashSet<HRegionInfo> regions = new HashSet<HRegionInfo>();
        ArrayList<byte[]> emptyRows = new ArrayList<byte[]>();
        try {
            while (true) {
                HRegionInfo info;
                Result values = null;
                try {
                    values = server.next(scannerId);
                }
                catch (IOException e) {
                    LOG.error((Object)"Shutdown scanning of meta region", (Throwable)RemoteExceptionHandler.checkIOException(e));
                    break;
                }
                if (values == null || values.size() == 0) break;
                byte[] row = values.getRow();
                String serverAddress = Bytes.toString(values.getValue(CATALOG_FAMILY, SERVER_QUALIFIER));
                long startCode = Bytes.toLong(values.getValue(CATALOG_FAMILY, STARTCODE_QUALIFIER));
                String serverName = null;
                if (serverAddress != null && serverAddress.length() > 0) {
                    serverName = HServerInfo.getServerName(serverAddress, startCode);
                }
                if (serverName == null || !this.deadServer.equals(serverName)) continue;
                if (LOG.isDebugEnabled() && row != null) {
                    LOG.debug((Object)("Shutdown scanner for " + serverName + " processing " + Bytes.toString(row)));
                }
                if ((info = this.master.getHRegionInfo(row, values)) == null) {
                    emptyRows.add(row);
                    continue;
                }
                RegionManager regionManager = this.master.regionManager;
                synchronized (regionManager) {
                    if (info.isMetaTable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("removing meta region " + Bytes.toString(info.getRegionName()) + " from online meta regions"));
                        }
                        this.master.regionManager.offlineMetaRegion(info.getStartKey());
                    }
                    ToDoEntry todo = new ToDoEntry(row, info);
                    toDoList.add(todo);
                    if (this.master.regionManager.isOfflined(info.getRegionNameAsString()) || info.isOffline()) {
                        this.master.regionManager.removeRegion(info);
                        if (!info.isOffline()) {
                            todo.regionOffline = true;
                        }
                    } else if (!info.isOffline() && !info.isSplit()) {
                        regions.add(info);
                    }
                }
            }
        }
        finally {
            if (scannerId != -1L) {
                try {
                    server.close(scannerId);
                }
                catch (IOException e) {
                    LOG.error((Object)"Closing scanner", (Throwable)RemoteExceptionHandler.checkIOException(e));
                }
            }
        }
        if (emptyRows.size() > 0) {
            LOG.warn((Object)("Found " + emptyRows.size() + " rows with empty HRegionInfo while scanning meta region " + Bytes.toString(regionName)));
            this.master.deleteEmptyMetaRows(server, regionName, emptyRows);
        }
        for (ToDoEntry e : toDoList) {
            if (!e.regionOffline) continue;
            HRegion.offlineRegionInMETA(server, regionName, e.info);
        }
        Iterator i$ = regions.iterator();
        while (i$.hasNext()) {
            HRegionInfo info = (HRegionInfo)((Object)i$.next());
            this.master.regionManager.setUnassigned(info, true);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean process() throws IOException {
        MetaRegion r;
        Boolean result;
        LOG.info((Object)("process shutdown of server " + this.deadServer + ": logSplit: " + this.logSplit + ", rootRescanned: " + this.rootRescanned + ", numberOfMetaRegions: " + this.master.regionManager.numMetaRegions() + ", onlineMetaRegions.size(): " + this.master.regionManager.numOnlineMetaRegions()));
        if (!this.logSplit) {
            if (this.master.fs.exists(this.oldLogDir)) {
                if (!this.master.regionManager.splitLogLock.tryLock()) {
                    return false;
                }
                try {
                    HLog.splitLog(this.master.rootdir, this.oldLogDir, this.master.fs, this.master.getConfiguration());
                }
                finally {
                    this.master.regionManager.splitLogLock.unlock();
                }
            }
            this.logSplit = true;
        }
        LOG.info((Object)"Log split complete, meta reassignment and scanning:");
        if (this.isRootServer) {
            LOG.info((Object)"ProcessServerShutdown reassigning ROOT region");
            this.master.regionManager.reassignRootRegion();
            this.isRootServer = false;
        }
        for (MetaRegion metaRegion : this.metaRegions) {
            LOG.info((Object)("ProcessServerShutdown setting to unassigned: " + metaRegion.toString()));
            this.master.regionManager.setUnassigned(metaRegion.getRegionInfo(), true);
        }
        this.metaRegions.clear();
        if (!this.rootAvailable()) {
            return true;
        }
        if (!this.rootRescanned) {
            Boolean result2 = (Boolean)new ScanRootRegion(new MetaRegion(this.master.getRootRegionLocation(), HRegionInfo.ROOT_REGIONINFO), this.master).doWithRetries();
            if (result2 == null) {
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("process server shutdown scanning root region on " + this.master.getRootRegionLocation().getBindAddress() + " finished " + Thread.currentThread().getName()));
            }
            this.rootRescanned = true;
        }
        if (!this.metaTableAvailable()) {
            return true;
        }
        List<MetaRegion> regions = this.master.regionManager.getListOfOnlineMetaRegions();
        Iterator<MetaRegion> i$ = regions.iterator();
        while (i$.hasNext() && (result = (Boolean)new ScanMetaRegions(r = i$.next(), this.master).doWithRetries()) != null) {
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("process server shutdown finished scanning " + Bytes.toString(r.getRegionName()) + " on " + r.getServer()));
        }
        this.master.serverManager.removeDeadServer(this.deadServer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removed " + this.deadServer + " from deadservers Map"));
        }
        return true;
    }

    @Override
    protected int getPriority() {
        return 2;
    }

    private class ScanMetaRegions
    extends RetryableMetaOperation<Boolean> {
        ScanMetaRegions(MetaRegion m, HMaster master) {
            super(m, master);
        }

        @Override
        public Boolean call() throws IOException {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("process server shutdown scanning " + Bytes.toString(this.m.getRegionName()) + " on " + this.m.getServer()));
            }
            Scan scan = new Scan();
            scan.addFamily(HConstants.CATALOG_FAMILY);
            long scannerId = this.server.openScanner(this.m.getRegionName(), scan);
            ProcessServerShutdown.this.scanMetaRegion(this.server, scannerId, this.m.getRegionName());
            return true;
        }
    }

    private class ScanRootRegion
    extends RetryableMetaOperation<Boolean> {
        ScanRootRegion(MetaRegion m, HMaster master) {
            super(m, master);
        }

        @Override
        public Boolean call() throws IOException {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("process server shutdown scanning root region on " + this.master.getRootRegionLocation().getBindAddress()));
            }
            Scan scan = new Scan();
            scan.addFamily(HConstants.CATALOG_FAMILY);
            long scannerId = this.server.openScanner(HRegionInfo.ROOT_REGIONINFO.getRegionName(), scan);
            ProcessServerShutdown.this.scanMetaRegion(this.server, scannerId, HRegionInfo.ROOT_REGIONINFO.getRegionName());
            return true;
        }
    }

    private static class ToDoEntry {
        boolean regionOffline = false;
        final byte[] row;
        final HRegionInfo info;

        ToDoEntry(byte[] row, HRegionInfo info) {
            this.row = row;
            this.info = info;
        }
    }
}

