/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class MasterMetrics
implements Updater {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final MetricsRecord metricsRecord;
    private final MetricsRegistry registry = new MetricsRegistry();
    private final MetricsIntValue cluster_requests = new MetricsIntValue("cluster_requests", this.registry);

    public MasterMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"master");
        String name = Thread.currentThread().getName();
        this.metricsRecord.setTag("Master", name);
        context.registerUpdater((Updater)this);
        JvmMetrics.init((String)"Master", (String)name);
        this.LOG.info((Object)"Initialized");
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        MasterMetrics masterMetrics = this;
        synchronized (masterMetrics) {
            MetricsIntValue metricsIntValue = this.cluster_requests;
            synchronized (metricsIntValue) {
                this.cluster_requests.pushMetric(this.metricsRecord);
                this.cluster_requests.set(0);
            }
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
    }

    public int getRequests() {
        return this.cluster_requests.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRequests(int inc) {
        MetricsIntValue metricsIntValue = this.cluster_requests;
        synchronized (metricsIntValue) {
            this.cluster_requests.set(this.cluster_requests.get() + inc);
        }
    }
}

