/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.util.StringUtils;

public class MetricsRate {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hbase.metrics");
    private String name;
    private int value;
    private float prevRate;
    private long ts;

    public MetricsRate(String name) {
        this.name = name;
        this.value = 0;
        this.prevRate = 0.0f;
        this.ts = System.currentTimeMillis();
    }

    public synchronized void inc(int incr) {
        this.value += incr;
    }

    public synchronized void inc() {
        ++this.value;
    }

    private synchronized void intervalHeartBeat() {
        long now = System.currentTimeMillis();
        long diff = (now - this.ts) / 1000L;
        if (diff == 0L) {
            diff = 1L;
        }
        this.prevRate = (float)this.value / (float)diff;
        this.value = 0;
        this.ts = now;
    }

    public synchronized void pushMetric(MetricsRecord mr) {
        this.intervalHeartBeat();
        try {
            mr.setMetric(this.name, this.getPreviousIntervalValue());
        }
        catch (Exception e) {
            LOG.info((Object)("pushMetric failed for " + this.name + "\n" + StringUtils.stringifyException((Throwable)e)));
        }
    }

    public synchronized float getPreviousIntervalValue() {
        return this.prevRate;
    }
}

