/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.WritableComparable;

public class HLogKey
implements WritableComparable<HLogKey>,
HeapSize {
    private byte[] regionName;
    private byte[] tablename;
    private long logSeqNum;
    private long writeTime;
    private int HEAP_TAX = ClassSize.OBJECT + 2 * ClassSize.ARRAY + 16;

    public HLogKey() {
        this(null, null, 0L, Long.MAX_VALUE);
    }

    public HLogKey(byte[] regionName, byte[] tablename, long logSeqNum, long now) {
        this.regionName = regionName;
        this.tablename = tablename;
        this.logSeqNum = logSeqNum;
        this.writeTime = now;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public byte[] getTablename() {
        return this.tablename;
    }

    public long getLogSeqNum() {
        return this.logSeqNum;
    }

    void setLogSeqNum(long logSeqNum) {
        this.logSeqNum = logSeqNum;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public String toString() {
        return Bytes.toString(this.tablename) + "/" + Bytes.toString(this.regionName) + "/" + this.logSeqNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HLogKey)obj) == 0;
    }

    public int hashCode() {
        int result = this.regionName.hashCode();
        result = (int)((long)result ^ this.logSeqNum);
        result = (int)((long)result ^ this.writeTime);
        return result;
    }

    public int compareTo(HLogKey o) {
        int result = Bytes.compareTo(this.regionName, o.regionName);
        if (result == 0) {
            if (this.logSeqNum < o.logSeqNum) {
                result = -1;
            } else if (this.logSeqNum > o.logSeqNum) {
                result = 1;
            }
            if (result == 0) {
                if (this.writeTime < o.writeTime) {
                    result = -1;
                } else if (this.writeTime > o.writeTime) {
                    return 1;
                }
            }
        }
        return result;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.regionName);
        Bytes.writeByteArray(out, this.tablename);
        out.writeLong(this.logSeqNum);
        out.writeLong(this.writeTime);
    }

    public void readFields(DataInput in) throws IOException {
        this.regionName = Bytes.readByteArray(in);
        this.tablename = Bytes.readByteArray(in);
        this.logSeqNum = in.readLong();
        this.writeTime = in.readLong();
    }

    @Override
    public long heapSize() {
        return this.regionName.length + this.tablename.length + this.HEAP_TAX;
    }
}

