/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;

public class KeyValueHeap
implements KeyValueScanner,
InternalScanner {
    private PriorityQueue<KeyValueScanner> heap;
    private KeyValueScanner current = null;
    private KVScannerComparator comparator;

    public KeyValueHeap(KeyValueScanner[] scanners, KeyValue.KVComparator comparator) {
        this.comparator = new KVScannerComparator(comparator);
        this.heap = new PriorityQueue<KeyValueScanner>(scanners.length, this.comparator);
        for (KeyValueScanner scanner : scanners) {
            if (scanner.peek() == null) continue;
            this.heap.add(scanner);
        }
        this.current = this.heap.poll();
    }

    @Override
    public KeyValue peek() {
        if (this.current == null) {
            return null;
        }
        return this.current.peek();
    }

    @Override
    public KeyValue next() {
        if (this.current == null) {
            return null;
        }
        KeyValue kvReturn = this.current.next();
        KeyValue kvNext = this.current.peek();
        if (kvNext == null) {
            this.current.close();
            this.current = this.heap.poll();
        } else {
            KeyValueScanner topScanner = this.heap.peek();
            if (topScanner == null || this.comparator.compare(kvNext, topScanner.peek()) > 0) {
                this.heap.add(this.current);
                this.current = this.heap.poll();
            }
        }
        return kvReturn;
    }

    @Override
    public boolean next(List<KeyValue> result) throws IOException {
        InternalScanner currentAsInternal = (InternalScanner)((Object)this.current);
        currentAsInternal.next(result);
        KeyValue pee = this.current.peek();
        if (pee == null) {
            this.current.close();
        } else {
            this.heap.add(this.current);
        }
        this.current = this.heap.poll();
        return this.current != null;
    }

    @Override
    public void close() {
        KeyValueScanner scanner;
        if (this.current != null) {
            this.current.close();
        }
        while ((scanner = this.heap.poll()) != null) {
            scanner.close();
        }
    }

    @Override
    public boolean seek(KeyValue seekKey) {
        KeyValueScanner scanner;
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        while ((scanner = this.heap.poll()) != null) {
            KeyValue topKey = scanner.peek();
            if (this.comparator.getComparator().compare(seekKey, topKey) <= 0) {
                this.current = scanner;
                return true;
            }
            if (!scanner.seek(seekKey)) {
                scanner.close();
                continue;
            }
            this.heap.add(scanner);
        }
        return false;
    }

    public PriorityQueue<KeyValueScanner> getHeap() {
        return this.heap;
    }

    private class KVScannerComparator
    implements Comparator<KeyValueScanner> {
        private KeyValue.KVComparator kvComparator;

        public KVScannerComparator(KeyValue.KVComparator kvComparator) {
            this.kvComparator = kvComparator;
        }

        @Override
        public int compare(KeyValueScanner left, KeyValueScanner right) {
            return this.compare(left.peek(), right.peek());
        }

        @Override
        public int compare(KeyValue left, KeyValue right) {
            return this.kvComparator.compare(left, right);
        }

        public KeyValue.KVComparator getComparator() {
            return this.kvComparator;
        }
    }
}

