/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.DeleteCompare;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

public class MemStore
implements HeapSize {
    private static final Log LOG = LogFactory.getLog(MemStore.class);
    volatile KeyValueSkipListSet kvset;
    volatile KeyValueSkipListSet snapshot;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final KeyValue.KVComparator comparator;
    final KeyValue.KVComparator comparatorIgnoreType;
    final KeyValue.KVComparator comparatorIgnoreTimestamp;
    final AtomicLong size;
    final CopyOnWriteArraySet<ChangedMemStoreObserver> changedMemStoreObservers = new CopyOnWriteArraySet();
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 8 * ClassSize.REFERENCE);
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.ATOMIC_LONG + (long)ClassSize.COPYONWRITE_ARRAYSET + (long)ClassSize.COPYONWRITE_ARRAYLIST + (long)(2 * ClassSize.CONCURRENT_SKIPLISTMAP));

    public MemStore() {
        this(KeyValue.COMPARATOR);
    }

    public MemStore(KeyValue.KVComparator c) {
        this.comparator = c;
        this.comparatorIgnoreTimestamp = this.comparator.getComparatorIgnoringTimestamps();
        this.comparatorIgnoreType = this.comparator.getComparatorIgnoringType();
        this.kvset = new KeyValueSkipListSet(c);
        this.snapshot = new KeyValueSkipListSet(c);
        this.size = new AtomicLong(DEEP_OVERHEAD);
    }

    void dump() {
        for (KeyValue kv : this.kvset) {
            LOG.info((Object)kv);
        }
        for (KeyValue kv : this.snapshot) {
            LOG.info((Object)kv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot() {
        this.lock.writeLock().lock();
        try {
            if (!this.snapshot.isEmpty()) {
                LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
            } else if (!this.kvset.isEmpty()) {
                this.snapshot = this.kvset;
                this.kvset = new KeyValueSkipListSet(this.comparator);
                this.tellChangedMemStoreObservers();
                this.size.set(DEEP_OVERHEAD);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void tellChangedMemStoreObservers() {
        for (ChangedMemStoreObserver o : this.changedMemStoreObservers) {
            o.changedMemStore();
        }
    }

    KeyValueSkipListSet getSnapshot() {
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSnapshot(KeyValueSkipListSet ss) throws UnexpectedException {
        this.lock.writeLock().lock();
        try {
            if (this.snapshot != ss) {
                throw new UnexpectedException("Current snapshot is " + this.snapshot + ", was passed " + ss);
            }
            if (!ss.isEmpty()) {
                this.snapshot = new KeyValueSkipListSet(this.comparator);
                this.tellChangedMemStoreObservers();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long add(KeyValue kv) {
        long s = -1L;
        this.lock.readLock().lock();
        try {
            s = this.heapSizeChange(kv, this.kvset.add(kv));
            this.size.addAndGet(s);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long delete(KeyValue delete) {
        long s = 0L;
        this.lock.readLock().lock();
        try {
            KeyValue kv2;
            DeleteCompare.DeleteCode res;
            boolean notpresent = false;
            ArrayList<KeyValue> deletes = new ArrayList<KeyValue>();
            SortedSet<KeyValue> tail = this.kvset.tailSet(delete);
            byte[] deleteBuffer = delete.getBuffer();
            int deleteOffset = delete.getOffset();
            int deleteKeyLen = Bytes.toInt(deleteBuffer, deleteOffset);
            short deleteRowLen = Bytes.toShort(deleteBuffer, deleteOffset += 8);
            int deleteRowOffset = deleteOffset += 2;
            byte deleteFamLen = deleteBuffer[deleteOffset += deleteRowLen];
            int deleteQualifierOffset = deleteOffset += 1 + deleteFamLen;
            int deleteQualifierLen = deleteKeyLen - deleteRowLen - deleteFamLen - 2 - 1 - 8 - 1;
            int deleteTimestampOffset = deleteOffset += deleteQualifierLen;
            byte deleteType = deleteBuffer[deleteOffset += 8];
            Iterator i$ = tail.iterator();
            while (i$.hasNext() && (res = DeleteCompare.deleteCompare(kv2 = (KeyValue)i$.next(), deleteBuffer, deleteRowOffset, deleteRowLen, deleteQualifierOffset, deleteQualifierLen, deleteTimestampOffset, deleteType, this.comparator.getRawComparator())) != DeleteCompare.DeleteCode.DONE) {
                if (res != DeleteCompare.DeleteCode.DELETE) continue;
                deletes.add(kv2);
            }
            for (KeyValue kv2 : deletes) {
                notpresent = this.kvset.remove(kv2);
                s -= this.heapSizeChange(kv2, notpresent);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.size.addAndGet(s += this.heapSizeChange(delete, this.kvset.add(delete)));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyValue getNextRow(KeyValue kv) {
        this.lock.readLock().lock();
        try {
            KeyValue keyValue = this.getLowest(this.getNextRow(kv, this.kvset), this.getNextRow(kv, this.snapshot));
            return keyValue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private KeyValue getLowest(KeyValue a, KeyValue b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    private KeyValue getNextRow(KeyValue key, NavigableSet<KeyValue> set) {
        KeyValue result = null;
        NavigableSet<KeyValue> tail = key == null ? set : set.tailSet(key);
        for (KeyValue kv : tail) {
            if (this.comparator.compareRows(kv, key) <= 0) continue;
            result = kv;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getRowKeyAtOrBefore(GetClosestRowBeforeTracker state) {
        this.lock.readLock().lock();
        try {
            this.getRowKeyAtOrBefore(this.kvset, state);
            this.getRowKeyAtOrBefore(this.snapshot, state);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void getRowKeyAtOrBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        if (set.isEmpty()) {
            return;
        }
        if (!this.walkForwardInSingleRow(set, state.getTargetKey(), state)) {
            this.getRowKeyBefore(set, state);
        }
    }

    private boolean walkForwardInSingleRow(SortedSet<KeyValue> set, KeyValue firstOnRow, GetClosestRowBeforeTracker state) {
        KeyValue kv;
        boolean foundCandidate = false;
        SortedSet<KeyValue> tail = set.tailSet(firstOnRow);
        if (tail.isEmpty()) {
            return foundCandidate;
        }
        Iterator i = tail.iterator();
        while (i.hasNext() && !state.isTooFar(kv = (KeyValue)i.next(), firstOnRow)) {
            if (state.isExpired(kv)) {
                i.remove();
                continue;
            }
            if (!state.handle(kv)) continue;
            foundCandidate = true;
            break;
        }
        return foundCandidate;
    }

    private void getRowKeyBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        KeyValue firstOnRow = state.getTargetKey();
        Member p = this.memberOfPreviousRow(set, state, firstOnRow);
        while (p != null && state.isTargetTable(p.kv) && state.isBetterCandidate(p.kv) && !this.walkForwardInSingleRow(p.set, firstOnRow = new KeyValue(p.kv.getRow(), Long.MAX_VALUE), state)) {
            p = this.memberOfPreviousRow(p.set, state, firstOnRow);
        }
    }

    private Member memberOfPreviousRow(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state, KeyValue firstOnRow) {
        NavigableSet<KeyValue> head = set.headSet(firstOnRow, false);
        if (head.isEmpty()) {
            return null;
        }
        Iterator<KeyValue> i = head.descendingIterator();
        while (i.hasNext()) {
            KeyValue found = i.next();
            if (state.isExpired(found)) {
                i.remove();
                continue;
            }
            return new Member(head, found);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyValueScanner[] getScanners() {
        this.lock.readLock().lock();
        try {
            KeyValueScanner[] scanners = new KeyValueScanner[]{new MemStoreScanner(this.changedMemStoreObservers)};
            KeyValueScanner[] keyValueScannerArray = scanners;
            return keyValueScannerArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(QueryMatcher matcher, List<KeyValue> result) throws IOException {
        this.lock.readLock().lock();
        try {
            if (this.internalGet(this.kvset, matcher, result) || matcher.isDone()) {
                boolean bl = true;
                return bl;
            }
            matcher.update();
            boolean bl = this.internalGet(this.snapshot, matcher, result) || matcher.isDone();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    boolean internalGet(NavigableSet<KeyValue> set, QueryMatcher matcher, List<KeyValue> result) throws IOException {
        if (set.isEmpty()) {
            return false;
        }
        SortedSet<KeyValue> tail = set.tailSet(matcher.getStartKey());
        block6: for (KeyValue kv : tail) {
            QueryMatcher.MatchCode res = matcher.match(kv);
            switch (res) {
                case INCLUDE: {
                    result.add(kv);
                    continue block6;
                }
                case SKIP: {
                    continue block6;
                }
                case NEXT: {
                    return false;
                }
                case DONE: {
                    return true;
                }
            }
            throw new RuntimeException("Unexpected " + (Object)((Object)res));
        }
        return false;
    }

    long heapSizeChange(KeyValue kv, boolean notpresent) {
        return notpresent ? ClassSize.align((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + kv.heapSize()) : 0L;
    }

    @Override
    public long heapSize() {
        return this.size.get();
    }

    public long keySize() {
        return this.heapSize() - DEEP_OVERHEAD;
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        MemStore memstore1 = new MemStore();
        long size = 0L;
        int count = 10000;
        byte[] column = Bytes.toBytes("col:umn");
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add(new KeyValue(Bytes.toBytes(i), column, (long)i));
        }
        LOG.info((Object)("memstore1 estimated size=" + size));
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add(new KeyValue(Bytes.toBytes(i), column, (long)i));
        }
        LOG.info((Object)("memstore1 estimated size (2nd loading of same data)=" + size));
        MemStore memstore2 = new MemStore();
        for (int i2 = 0; i2 < 10000; ++i2) {
            size += memstore2.add(new KeyValue(Bytes.toBytes(i2), column, i2, new byte[i2]));
        }
        LOG.info((Object)("memstore2 estimated size=" + size));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        for (int i3 = 0; i3 < 30; ++i3) {
        }
        LOG.info((Object)"Exiting.");
    }

    static interface ChangedMemStoreObserver {
        public void changedMemStore();
    }

    private static class FirstOnRow {
        private KeyValue firstOnRow = null;

        FirstOnRow() {
        }

        synchronized void set(KeyValue kv) {
            this.firstOnRow = kv;
        }

        synchronized void reset() {
            if (this.firstOnRow == null) {
                return;
            }
            this.firstOnRow = new KeyValue(this.firstOnRow.getRow(), Long.MAX_VALUE);
        }

        synchronized KeyValue get() {
            return this.firstOnRow;
        }
    }

    protected class MemStoreScanner
    implements KeyValueScanner,
    ChangedMemStoreObserver {
        private List<KeyValue> result = new ArrayList<KeyValue>();
        private int idx = 0;
        private FirstOnRow firstOnNextRow = new FirstOnRow();
        private final Set<ChangedMemStoreObserver> observers;

        MemStoreScanner(Set<ChangedMemStoreObserver> observers) {
            this.observers = observers;
            this.observers.add(this);
        }

        @Override
        public boolean seek(KeyValue key) {
            try {
                if (key == null) {
                    this.close();
                    return false;
                }
                this.firstOnNextRow.set(key);
                return this.cacheNextRow();
            }
            catch (Exception e) {
                this.close();
                return false;
            }
        }

        @Override
        public KeyValue peek() {
            if (this.idx >= this.result.size()) {
                if (!this.cacheNextRow()) {
                    return null;
                }
                return this.peek();
            }
            return this.result.get(this.idx);
        }

        @Override
        public KeyValue next() {
            if (this.idx >= this.result.size()) {
                if (!this.cacheNextRow()) {
                    return null;
                }
                return this.next();
            }
            return this.result.get(this.idx++);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cacheNextRow() {
            MemStore.this.lock.readLock().lock();
            this.result.clear();
            this.idx = 0;
            try {
                KeyValue kvsetNextRow = this.cacheNextRow(MemStore.this.kvset);
                KeyValue snapshotNextRow = this.cacheNextRow(MemStore.this.snapshot);
                if (kvsetNextRow == null && snapshotNextRow == null) {
                    this.firstOnNextRow.set(null);
                    boolean bl = !this.result.isEmpty();
                    return bl;
                }
                if (kvsetNextRow != null && snapshotNextRow != null) {
                    int compare = MemStore.this.comparator.compare(kvsetNextRow, snapshotNextRow);
                    this.firstOnNextRow.set(compare <= 0 ? kvsetNextRow : snapshotNextRow);
                } else {
                    this.firstOnNextRow.set(kvsetNextRow != null ? kvsetNextRow : snapshotNextRow);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                MemStore.this.lock.readLock().unlock();
            }
        }

        private KeyValue cacheNextRow(NavigableSet<KeyValue> set) {
            if (this.firstOnNextRow.get() == null || set.isEmpty()) {
                return null;
            }
            SortedSet<KeyValue> tail = set.tailSet(this.firstOnNextRow.get());
            if (tail == null || tail.isEmpty()) {
                return null;
            }
            KeyValue first = tail.first();
            KeyValue nextRow = null;
            for (KeyValue kv : tail) {
                if (MemStore.this.comparator.compareRows(first, kv) != 0) {
                    nextRow = kv;
                    break;
                }
                this.result.add(kv);
            }
            return nextRow;
        }

        @Override
        public void close() {
            this.firstOnNextRow.set(null);
            this.idx = 0;
            if (!this.result.isEmpty()) {
                this.result.clear();
            }
            this.observers.remove(this);
        }

        @Override
        public void changedMemStore() {
            this.firstOnNextRow.reset();
        }
    }

    private class Member {
        final KeyValue kv;
        final NavigableSet<KeyValue> set;

        Member(NavigableSet<KeyValue> s, KeyValue kv) {
            this.kv = kv;
            this.set = s;
        }
    }
}

