/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.NavigableSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.GetDeleteTracker;
import org.apache.hadoop.hbase.regionserver.WildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class QueryMatcher {
    protected DeleteTracker deletes;
    protected ColumnTracker columns;
    protected KeyValue startKey;
    KeyValue.KeyComparator rowComparator;
    protected byte[] row;
    protected TimeRange tr;
    protected long oldestStamp;
    protected Filter filter;

    public QueryMatcher(Get get2, byte[] family, NavigableSet<byte[]> columns, long ttl, KeyValue.KeyComparator rowComparator, int maxVersions) {
        this.row = get2.getRow();
        this.filter = get2.getFilter();
        this.tr = get2.getTimeRange();
        this.oldestStamp = System.currentTimeMillis() - ttl;
        this.rowComparator = rowComparator;
        this.deletes = new GetDeleteTracker();
        this.startKey = KeyValue.createFirstOnRow(this.row);
        this.columns = columns == null || columns.size() == 0 ? new WildcardColumnTracker(maxVersions) : new ExplicitColumnTracker(columns, maxVersions);
    }

    protected QueryMatcher() {
    }

    public QueryMatcher(QueryMatcher matcher, byte[] row) {
        this.row = row;
        this.filter = matcher.filter;
        this.tr = matcher.getTimeRange();
        this.oldestStamp = matcher.getOldestStamp();
        this.rowComparator = matcher.getRowComparator();
        this.columns = matcher.getColumnTracker();
        this.deletes = matcher.getDeleteTracker();
        this.startKey = matcher.getStartKey();
        this.reset();
    }

    public MatchCode match(KeyValue kv) {
        short rowLength;
        int ret;
        if (this.columns.done()) {
            return MatchCode.DONE;
        }
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return MatchCode.DONE;
        }
        byte[] bytes = kv.getBuffer();
        int offset = kv.getOffset();
        int keyLength = Bytes.toInt(bytes, offset);
        offset += 8;
        if ((ret = this.rowComparator.compareRows(this.row, 0, this.row.length, bytes, offset += 2, rowLength = Bytes.toShort(bytes, offset))) <= -1) {
            return MatchCode.NEXT;
        }
        if (ret >= 1) {
            return MatchCode.SKIP;
        }
        byte familyLength = bytes[offset += rowLength];
        int columnLength = keyLength + 8 - ((offset += 1 + familyLength) - kv.getOffset()) - 9;
        int columnOffset = offset;
        long timestamp = Bytes.toLong(bytes, offset += columnLength);
        if (this.isExpired(timestamp)) {
            return MatchCode.NEXT;
        }
        byte type = bytes[offset += 8];
        if (this.isDelete(type)) {
            if (this.tr.withinOrAfterTimeRange(timestamp)) {
                this.deletes.add(bytes, columnOffset, columnLength, timestamp, type);
            }
            return MatchCode.SKIP;
        }
        if (!this.tr.withinTimeRange(timestamp)) {
            return MatchCode.SKIP;
        }
        if (!this.deletes.isEmpty() && this.deletes.isDeleted(bytes, columnOffset, columnLength, timestamp)) {
            return MatchCode.SKIP;
        }
        MatchCode mc = this.columns.checkColumn(bytes, columnOffset, columnLength);
        if (mc == MatchCode.INCLUDE && this.filter != null) {
            switch (this.filter.filterKeyValue(kv)) {
                case INCLUDE: {
                    return MatchCode.INCLUDE;
                }
                case SKIP: {
                    return MatchCode.SKIP;
                }
            }
            return MatchCode.DONE;
        }
        return mc;
    }

    protected boolean isDelete(byte type) {
        return type != KeyValue.Type.Put.getCode();
    }

    protected boolean isExpired(long timestamp) {
        return timestamp < this.oldestStamp;
    }

    public ColumnCount getSeekColumn() {
        return this.columns.getColumnHint();
    }

    public void update() {
        this.deletes.update();
        this.columns.update();
    }

    public void reset() {
        this.deletes.reset();
        this.columns.reset();
    }

    public void setRow(byte[] row) {
        this.row = row;
    }

    public KeyValue getStartKey() {
        return this.startKey;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public long getOldestStamp() {
        return this.oldestStamp;
    }

    public KeyValue.KeyComparator getRowComparator() {
        return this.rowComparator;
    }

    public ColumnTracker getColumnTracker() {
        return this.columns;
    }

    public DeleteTracker getDeleteTracker() {
        return this.deletes;
    }

    public boolean isDone() {
        return this.columns.done();
    }

    static enum MatchCode {
        INCLUDE,
        SKIP,
        NEXT,
        DONE,
        SEEK_NEXT_ROW,
        SEEK_NEXT_COL,
        DONE_SCAN;

    }
}

