/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.NavigableSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanQueryMatcher
extends QueryMatcher {
    private RowFilterInterface oldFilter;
    private boolean stickyNextRow;
    private KeyValue stopKey = null;

    public ScanQueryMatcher(Scan scan, byte[] family, NavigableSet<byte[]> columns, long ttl, KeyValue.KeyComparator rowComparator, int maxVersions) {
        this.tr = scan.getTimeRange();
        this.oldestStamp = System.currentTimeMillis() - ttl;
        this.rowComparator = rowComparator;
        this.deletes = new ScanDeleteTracker();
        this.startKey = KeyValue.createFirstOnRow(scan.getStartRow());
        this.stopKey = KeyValue.createFirstOnRow(scan.getStopRow());
        this.filter = scan.getFilter();
        this.oldFilter = scan.getOldFilter();
        this.columns = columns == null || columns.size() == 0 ? new ScanWildcardColumnTracker(maxVersions) : new ExplicitColumnTracker(columns, maxVersions);
    }

    @Override
    public QueryMatcher.MatchCode match(KeyValue kv) {
        short rowLength;
        int ret;
        int offset;
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return QueryMatcher.MatchCode.DONE_SCAN;
        }
        if (this.oldFilter != null && this.oldFilter.filterAllRemaining()) {
            return QueryMatcher.MatchCode.DONE_SCAN;
        }
        byte[] bytes = kv.getBuffer();
        int initialOffset = offset = kv.getOffset();
        int keyLength = Bytes.toInt(bytes, offset, 4);
        offset += 8;
        if ((ret = this.rowComparator.compareRows(this.row, 0, this.row.length, bytes, offset += 2, rowLength = Bytes.toShort(bytes, offset, 2))) <= -1) {
            return QueryMatcher.MatchCode.DONE;
        }
        if (ret >= 1) {
            return QueryMatcher.MatchCode.SKIP;
        }
        if (this.stickyNextRow) {
            return QueryMatcher.MatchCode.SEEK_NEXT_ROW;
        }
        if (this.columns.done()) {
            this.stickyNextRow = true;
            return QueryMatcher.MatchCode.SEEK_NEXT_ROW;
        }
        byte familyLength = bytes[offset += rowLength];
        int qualLength = keyLength + 8 - ((offset += familyLength + 1) - initialOffset) - 9;
        long timestamp = kv.getTimestamp();
        if (this.isExpired(timestamp)) {
            this.stickyNextRow = true;
            return QueryMatcher.MatchCode.SEEK_NEXT_ROW;
        }
        byte type = kv.getType();
        if (this.isDelete(type)) {
            if (this.tr.withinOrAfterTimeRange(timestamp)) {
                this.deletes.add(bytes, offset, qualLength, timestamp, type);
            }
            return QueryMatcher.MatchCode.SKIP;
        }
        if (!this.tr.withinTimeRange(timestamp)) {
            return QueryMatcher.MatchCode.SKIP;
        }
        if (!this.deletes.isEmpty() && this.deletes.isDeleted(bytes, offset, qualLength, timestamp)) {
            return QueryMatcher.MatchCode.SKIP;
        }
        QueryMatcher.MatchCode colChecker = this.columns.checkColumn(bytes, offset, qualLength);
        if (colChecker == QueryMatcher.MatchCode.SKIP) {
            return QueryMatcher.MatchCode.SEEK_NEXT_COL;
        }
        if (colChecker == QueryMatcher.MatchCode.NEXT || colChecker == QueryMatcher.MatchCode.DONE) {
            this.stickyNextRow = true;
            return QueryMatcher.MatchCode.SEEK_NEXT_ROW;
        }
        if (this.filter == null) {
            return QueryMatcher.MatchCode.INCLUDE;
        }
        Filter.ReturnCode filterResponse = this.filter.filterKeyValue(kv);
        if (filterResponse == Filter.ReturnCode.INCLUDE) {
            return QueryMatcher.MatchCode.INCLUDE;
        }
        if (filterResponse == Filter.ReturnCode.SKIP) {
            return QueryMatcher.MatchCode.SKIP;
        }
        this.stickyNextRow = true;
        return QueryMatcher.MatchCode.SEEK_NEXT_ROW;
    }

    @Override
    public void setRow(byte[] row) {
        this.row = row;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.stickyNextRow = false;
    }
}

