/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class ScanWildcardColumnTracker
implements ColumnTracker {
    private byte[] columnBuffer = null;
    private int columnOffset = 0;
    private int columnLength = 0;
    private int currentCount = 0;
    private int maxVersions;

    public ScanWildcardColumnTracker(int maxVersion) {
        this.maxVersions = maxVersion;
    }

    @Override
    public QueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length) {
        if (this.columnBuffer == null) {
            this.columnBuffer = bytes;
            this.columnOffset = offset;
            this.columnLength = length;
            this.currentCount = 0;
            if (++this.currentCount > this.maxVersions) {
                return QueryMatcher.MatchCode.SKIP;
            }
            return QueryMatcher.MatchCode.INCLUDE;
        }
        int cmp = Bytes.compareTo(bytes, offset, length, this.columnBuffer, this.columnOffset, this.columnLength);
        if (cmp == 0) {
            if (++this.currentCount > this.maxVersions) {
                return QueryMatcher.MatchCode.SKIP;
            }
            return QueryMatcher.MatchCode.INCLUDE;
        }
        if (cmp > 0) {
            this.columnBuffer = bytes;
            this.columnOffset = offset;
            this.columnLength = length;
            this.currentCount = 0;
            if (++this.currentCount > this.maxVersions) {
                return QueryMatcher.MatchCode.SKIP;
            }
            return QueryMatcher.MatchCode.INCLUDE;
        }
        throw new RuntimeException("ScanWildcardColumnTracker.checkColumn ran into a column actually smaller than the previous column!");
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException("ScanWildcardColumnTracker.update should never be called!");
    }

    @Override
    public void reset() {
        this.columnBuffer = null;
    }

    @Override
    public ColumnCount getColumnHint() {
        return null;
    }

    @Override
    public boolean done() {
        return false;
    }
}

