/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.HalfHFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.util.StringUtils;

public class StoreFile
implements HConstants {
    static final Log LOG = LogFactory.getLog((String)StoreFile.class.getName());
    private static final String HFILE_CACHE_SIZE_KEY = "hfile.block.cache.size";
    private static BlockCache hfileBlockCache = null;
    private static final int DEFAULT_BLOCKSIZE_SMALL = 8192;
    private final FileSystem fs;
    private final Path path;
    private Reference reference;
    private Path referencePath;
    private boolean blockcache;
    private boolean inMemory;
    private static final byte[] MAX_SEQ_ID_KEY = Bytes.toBytes("MAX_SEQ_ID_KEY");
    private long sequenceid = -1L;
    private static final byte[] MAJOR_COMPACTION_KEY = Bytes.toBytes("MAJOR_COMPACTION_KEY");
    private AtomicBoolean majorCompaction = null;
    private static final Pattern REF_NAME_PARSER = Pattern.compile("^(\\d+)(?:\\.(.+))?$");
    private volatile HFile.Reader reader;
    private static final Random rand = new Random();
    private final HBaseConfiguration conf;

    StoreFile(FileSystem fs, Path p, boolean blockcache, HBaseConfiguration conf, boolean inMemory) throws IOException {
        this.conf = conf;
        this.fs = fs;
        this.path = p;
        this.blockcache = blockcache;
        this.inMemory = inMemory;
        if (StoreFile.isReference(p)) {
            this.reference = Reference.read(fs, p);
            this.referencePath = StoreFile.getReferredToFile(this.path);
        }
        this.reader = this.open();
    }

    Path getPath() {
        return this.path;
    }

    byte[] getFamily() {
        return Bytes.toBytes(this.path.getParent().getName());
    }

    boolean isReference() {
        return this.reference != null;
    }

    public static boolean isReference(Path p) {
        return StoreFile.isReference(p, REF_NAME_PARSER.matcher(p.getName()));
    }

    public static boolean isReference(Path p, Matcher m) {
        if (m == null || !m.matches()) {
            LOG.warn((Object)("Failed match of store file name " + p.toString()));
            throw new RuntimeException("Failed match of store file name " + p.toString());
        }
        return m.groupCount() > 1 && m.group(2) != null;
    }

    static Path getReferredToFile(Path p) {
        Matcher m = REF_NAME_PARSER.matcher(p.getName());
        if (m == null || !m.matches()) {
            LOG.warn((Object)("Failed match of store file name " + p.toString()));
            throw new RuntimeException("Failed match of store file name " + p.toString());
        }
        String otherRegion = m.group(2);
        Path tableDir = p.getParent().getParent().getParent();
        String nameStrippedOfSuffix = m.group(1);
        return new Path(new Path(new Path(tableDir, otherRegion), p.getParent().getName()), nameStrippedOfSuffix);
    }

    boolean isMajorCompaction() {
        if (this.majorCompaction == null) {
            throw new NullPointerException("This has not been set yet");
        }
        return this.majorCompaction.get();
    }

    public long getMaxSequenceId() {
        if (this.sequenceid == -1L) {
            throw new IllegalAccessError("Has not been initialized");
        }
        return this.sequenceid;
    }

    public static synchronized BlockCache getBlockCache(HBaseConfiguration conf) {
        if (hfileBlockCache != null) {
            return hfileBlockCache;
        }
        float cachePercentage = conf.getFloat(HFILE_CACHE_SIZE_KEY, 0.0f);
        if (cachePercentage == 0.0f) {
            return null;
        }
        if ((double)cachePercentage > 1.0) {
            throw new IllegalArgumentException("hfile.block.cache.size must be between 0.0 and 1.0, not > 1.0");
        }
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long cacheSize = (long)((float)mu.getMax() * cachePercentage);
        LOG.info((Object)("Allocating LruBlockCache with maximum size " + StringUtils.humanReadableInt((long)cacheSize)));
        hfileBlockCache = new LruBlockCache(cacheSize, 8192L);
        return hfileBlockCache;
    }

    public BlockCache getBlockCache() {
        return this.blockcache ? StoreFile.getBlockCache(this.conf) : null;
    }

    protected HFile.Reader open() throws IOException {
        if (this.reader != null) {
            throw new IllegalAccessError("Already open");
        }
        this.reader = this.isReference() ? new HalfHFileReader(this.fs, this.referencePath, this.getBlockCache(), this.reference) : new HFile.Reader(this.fs, this.path, this.getBlockCache(), this.inMemory);
        Map<byte[], byte[]> map = this.reader.loadFileInfo();
        byte[] b = map.get(MAX_SEQ_ID_KEY);
        if (b != null) {
            this.sequenceid = Bytes.toLong(b);
            if (this.isReference() && Reference.isTopFileRegion(this.reference.getFileRegion())) {
                ++this.sequenceid;
            }
        }
        if ((b = map.get(MAJOR_COMPACTION_KEY)) != null) {
            boolean mc = Bytes.toBoolean(b);
            if (this.majorCompaction == null) {
                this.majorCompaction = new AtomicBoolean(mc);
            } else {
                this.majorCompaction.set(mc);
            }
        }
        return this.reader;
    }

    public HFile.Reader getReader() {
        return this.reader;
    }

    public synchronized void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public String toString() {
        return this.path.toString() + (this.isReference() ? "-" + this.referencePath + "-" + this.reference.toString() : "");
    }

    public void delete() throws IOException {
        this.close();
        this.fs.delete(this.getPath(), true);
    }

    public static Path rename(FileSystem fs, Path src, Path tgt) throws IOException {
        if (!fs.exists(src)) {
            throw new FileNotFoundException(src.toString());
        }
        if (!fs.rename(src, tgt)) {
            throw new IOException("Failed rename of " + src + " to " + tgt);
        }
        return tgt;
    }

    public static HFile.Writer getWriter(FileSystem fs, Path dir) throws IOException {
        return StoreFile.getWriter(fs, dir, 8192, null, null);
    }

    public static HFile.Writer getWriter(FileSystem fs, Path dir, int blocksize, Compression.Algorithm algorithm, KeyValue.KeyComparator c) throws IOException {
        if (!fs.exists(dir)) {
            fs.mkdirs(dir);
        }
        Path path = StoreFile.getUniqueFile(fs, dir);
        return new HFile.Writer(fs, path, blocksize, algorithm == null ? HFile.DEFAULT_COMPRESSION_ALGORITHM : algorithm, (RawComparator<byte[]>)(c == null ? KeyValue.KEY_COMPARATOR : c));
    }

    static Path getUniqueFile(FileSystem fs, Path p) throws IOException {
        if (!fs.getFileStatus(p).isDir()) {
            throw new IOException("Expecting a directory");
        }
        return fs.getFileStatus(p).isDir() ? StoreFile.getRandomFilename(fs, p) : p;
    }

    static Path getRandomFilename(FileSystem fs, Path dir) throws IOException {
        return StoreFile.getRandomFilename(fs, dir, null);
    }

    static Path getRandomFilename(FileSystem fs, Path dir, String suffix) throws IOException {
        long id = -1L;
        Path p = null;
        while (fs.exists(p = new Path(dir, Long.toString(id = Math.abs(rand.nextLong())) + (suffix == null || suffix.length() <= 0 ? "" : suffix)))) {
        }
        return p;
    }

    static void appendMetadata(HFile.Writer w, long maxSequenceId) throws IOException {
        StoreFile.appendMetadata(w, maxSequenceId, false);
    }

    public static void appendMetadata(HFile.Writer w, long maxSequenceId, boolean mc) throws IOException {
        w.appendFileInfo(MAX_SEQ_ID_KEY, Bytes.toBytes(maxSequenceId));
        w.appendFileInfo(MAJOR_COMPACTION_KEY, Bytes.toBytes(mc));
    }

    static Path split(FileSystem fs, Path splitDir, StoreFile f, byte[] splitRow, Reference.Range range) throws IOException {
        Reference r = new Reference(splitRow, range);
        String parentRegionName = f.getPath().getParent().getParent().getName();
        Path p = new Path(splitDir, f.getPath().getName() + "." + parentRegionName);
        return r.write(fs, p);
    }
}

