/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;

class StoreScanner
implements KeyValueScanner,
InternalScanner,
ChangedReadersObserver {
    static final Log LOG = LogFactory.getLog(StoreScanner.class);
    private Store store;
    private ScanQueryMatcher matcher;
    private KeyValueHeap heap;
    private final AtomicBoolean closing = new AtomicBoolean(false);

    StoreScanner(Store store, Scan scan, NavigableSet<byte[]> columns) {
        this.store = store;
        this.matcher = new ScanQueryMatcher(scan, store.getFamily().getName(), columns, store.ttl, store.comparator.getRawComparator(), store.versionsToReturn(scan.getMaxVersions()));
        List<KeyValueScanner> scanners = this.getScanners();
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners.toArray(new KeyValueScanner[scanners.size()]), store.comparator);
        this.store.addChangedReaderObserver(this);
    }

    StoreScanner(Store store, Scan scan, KeyValueScanner[] scanners) {
        this.store = store;
        this.matcher = new ScanQueryMatcher(scan, store.getFamily().getName(), null, store.ttl, store.comparator.getRawComparator(), store.versionsToReturn(scan.getMaxVersions()));
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
    }

    StoreScanner(Scan scan, byte[] colFamily, long ttl, KeyValue.KVComparator comparator, NavigableSet<byte[]> columns, KeyValueScanner[] scanners) {
        this.store = null;
        this.matcher = new ScanQueryMatcher(scan, colFamily, columns, ttl, comparator.getRawComparator(), scan.getMaxVersions());
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(this.matcher.getStartKey());
        }
        this.heap = new KeyValueHeap(scanners, comparator);
    }

    private List<KeyValueScanner> getScanners() {
        List<KeyValueScanner> scanners = this.getStoreFileScanners();
        KeyValueScanner[] memstorescanners = this.store.memstore.getScanners();
        for (int i = memstorescanners.length - 1; i >= 0; --i) {
            scanners.add(memstorescanners[i]);
        }
        return scanners;
    }

    @Override
    public synchronized KeyValue peek() {
        return this.heap.peek();
    }

    @Override
    public KeyValue next() {
        throw new RuntimeException("Never call StoreScanner.next()");
    }

    @Override
    public synchronized void close() {
        this.closing.set(true);
        if (this.store != null) {
            this.store.deleteChangedReaderObserver(this);
        }
        this.heap.close();
    }

    @Override
    public synchronized boolean seek(KeyValue key) {
        return this.heap.seek(key);
    }

    @Override
    public synchronized boolean next(List<KeyValue> outResult) throws IOException {
        KeyValue kv;
        KeyValue peeked = this.heap.peek();
        if (peeked == null) {
            this.close();
            return false;
        }
        this.matcher.setRow(peeked.getRow());
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        block8: while ((kv = this.heap.peek()) != null) {
            QueryMatcher.MatchCode qcode = this.matcher.match(kv);
            switch (qcode) {
                case INCLUDE: {
                    KeyValue next = this.heap.next();
                    results.add(next);
                    continue block8;
                }
                case DONE: {
                    outResult.addAll(results);
                    return true;
                }
                case DONE_SCAN: {
                    this.close();
                    outResult.addAll(results);
                    return false;
                }
                case SEEK_NEXT_ROW: {
                    this.heap.next();
                    continue block8;
                }
                case SEEK_NEXT_COL: {
                    this.heap.next();
                    continue block8;
                }
                case SKIP: {
                    this.heap.next();
                    continue block8;
                }
            }
            throw new RuntimeException("UNEXPECTED");
        }
        if (!results.isEmpty()) {
            outResult.addAll(results);
            return true;
        }
        this.close();
        return false;
    }

    private List<KeyValueScanner> getStoreFileScanners() {
        ArrayList<HFileScanner> s = new ArrayList<HFileScanner>(this.store.getStorefilesCount());
        NavigableMap<Long, StoreFile> map = this.store.getStorefiles().descendingMap();
        for (StoreFile sf : map.values()) {
            HFile.Reader r = sf.getReader();
            if (r == null) {
                LOG.warn((Object)("StoreFile " + sf + " has null Reader"));
                continue;
            }
            s.add(r.getScanner());
        }
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(s.size() + 1);
        for (HFileScanner hfs : s) {
            scanners.add(new StoreFileScanner(hfs));
        }
        return scanners;
    }

    @Override
    public synchronized void updateReaders() throws IOException {
        if (this.closing.get()) {
            return;
        }
        KeyValue topKey = this.peek();
        if (topKey == null) {
            return;
        }
        List<KeyValueScanner> scanners = this.getScanners();
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(topKey);
        }
        this.heap = new KeyValueHeap(scanners.toArray(new KeyValueScanner[scanners.size()]), this.store.comparator);
        this.matcher.reset();
        this.matcher.setRow(this.heap.peek().getRow());
    }
}

