/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class WildcardColumnTracker
implements ColumnTracker {
    private int maxVersions;
    protected List<ColumnCount> columns;
    private int index;
    private ColumnCount column;
    private List<ColumnCount> newColumns;
    private int newIndex;
    private ColumnCount newColumn;

    public WildcardColumnTracker(int maxVersions) {
        this.maxVersions = maxVersions;
        this.reset();
    }

    @Override
    public void reset() {
        this.index = 0;
        this.column = null;
        this.columns = null;
        this.newColumns = new ArrayList<ColumnCount>();
        this.newIndex = 0;
        this.newColumn = null;
    }

    @Override
    public boolean done() {
        return false;
    }

    @Override
    public ColumnCount getColumnHint() {
        return null;
    }

    @Override
    public QueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length) {
        if (this.column == null && this.newColumn == null) {
            this.newColumns.add(new ColumnCount(bytes, offset, length, 1));
            this.newColumn = this.newColumns.get(this.newIndex);
            return QueryMatcher.MatchCode.INCLUDE;
        }
        if (this.column == null && this.newColumn != null) {
            int ret = Bytes.compareTo(this.newColumn.getBuffer(), this.newColumn.getOffset(), this.newColumn.getLength(), bytes, offset, length);
            if (ret == 0) {
                if (this.newColumn.increment() > this.maxVersions) {
                    return QueryMatcher.MatchCode.SKIP;
                }
                return QueryMatcher.MatchCode.INCLUDE;
            }
            if (ret <= -1) {
                if (++this.newIndex == this.newColumns.size()) {
                    this.newColumns.add(new ColumnCount(bytes, offset, length, 1));
                    this.newColumn = this.newColumns.get(this.newIndex);
                    return QueryMatcher.MatchCode.INCLUDE;
                }
                this.newColumn = this.newColumns.get(this.newIndex);
                return this.checkColumn(bytes, offset, length);
            }
            this.newColumns.add(new ColumnCount(bytes, offset, length, 1));
            this.newColumn = this.newColumns.get(++this.newIndex);
            return QueryMatcher.MatchCode.INCLUDE;
        }
        if (this.newColumn == null && this.column != null) {
            int ret = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), bytes, offset, length);
            if (ret == 0) {
                if (this.column.increment() > this.maxVersions) {
                    return QueryMatcher.MatchCode.SKIP;
                }
                return QueryMatcher.MatchCode.INCLUDE;
            }
            if (ret <= -1) {
                if (++this.index == this.columns.size()) {
                    this.newColumns.add(new ColumnCount(bytes, offset, length, 1));
                    this.newColumn = this.newColumns.get(this.newIndex);
                    this.column = null;
                    return QueryMatcher.MatchCode.INCLUDE;
                }
                this.column = this.columns.get(this.index);
                return this.checkColumn(bytes, offset, length);
            }
            this.newColumns.add(new ColumnCount(bytes, offset, length, 1));
            this.newColumn = this.newColumns.get(this.newIndex);
            return QueryMatcher.MatchCode.INCLUDE;
        }
        int ret = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), this.newColumn.getBuffer(), this.newColumn.getOffset(), this.newColumn.getLength());
        if (ret <= -1) {
            ret = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), bytes, offset, length);
            if (ret == 0) {
                if (this.column.increment() > this.maxVersions) {
                    return QueryMatcher.MatchCode.SKIP;
                }
                return QueryMatcher.MatchCode.INCLUDE;
            }
            if (ret <= -1) {
                this.column = ++this.index == this.columns.size() ? null : this.columns.get(this.index);
                return this.checkColumn(bytes, offset, length);
            }
            this.newColumns.add(new ColumnCount(bytes, offset, length, 1));
            return QueryMatcher.MatchCode.INCLUDE;
        }
        ret = Bytes.compareTo(this.newColumn.getBuffer(), this.newColumn.getOffset(), this.newColumn.getLength(), bytes, offset, length);
        if (ret == 0) {
            if (this.newColumn.increment() > this.maxVersions) {
                return QueryMatcher.MatchCode.SKIP;
            }
            return QueryMatcher.MatchCode.INCLUDE;
        }
        if (ret <= -1) {
            this.newColumn = ++this.newIndex == this.newColumns.size() ? null : this.newColumns.get(this.newIndex);
            return this.checkColumn(bytes, offset, length);
        }
        this.newColumns.add(new ColumnCount(bytes, offset, length, 1));
        return QueryMatcher.MatchCode.INCLUDE;
    }

    @Override
    public void update() {
        if (this.columns == null || this.columns.size() == 0) {
            if (this.newColumns.size() > 0) {
                this.finalize(this.newColumns);
            }
            return;
        }
        if (this.newColumns.size() == 0) {
            this.index = 0;
            this.column = this.columns.get(this.index);
            return;
        }
        ArrayList<ColumnCount> mergeColumns = new ArrayList<ColumnCount>(this.columns.size() + this.newColumns.size());
        this.index = 0;
        this.newIndex = 0;
        this.column = this.columns.get(0);
        this.newColumn = this.newColumns.get(0);
        while (true) {
            int ret;
            if ((ret = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), this.newColumn.getBuffer(), this.newColumn.getOffset(), this.newColumn.getLength())) <= -1) {
                mergeColumns.add(this.column);
                if (++this.index == this.columns.size()) {
                    this.mergeDown(mergeColumns, this.newColumns, this.newIndex);
                    this.finalize(mergeColumns);
                    return;
                }
                this.column = this.columns.get(this.index);
                continue;
            }
            mergeColumns.add(this.newColumn);
            if (++this.newIndex == this.newColumns.size()) {
                this.mergeDown(mergeColumns, this.columns, this.index);
                this.finalize(mergeColumns);
                return;
            }
            this.newColumn = this.newColumns.get(this.newIndex);
        }
    }

    private void mergeDown(List<ColumnCount> mergeColumns, List<ColumnCount> srcColumns, int srcIndex) {
        int index = srcIndex;
        while (index < srcColumns.size()) {
            mergeColumns.add(srcColumns.get(index++));
        }
    }

    private void finalize(List<ColumnCount> mergeColumns) {
        this.columns = mergeColumns;
        this.index = 0;
        this.column = this.columns.size() > 0 ? this.columns.get(this.index) : null;
        this.newColumns = new ArrayList<ColumnCount>();
        this.newIndex = 0;
        this.newColumn = null;
    }
}

