/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class RegionServerMetrics
implements Updater {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private final MetricsRecord metricsRecord;
    private long lastUpdate = System.currentTimeMillis();
    private static final int MB = 0x100000;
    private MetricsRegistry registry = new MetricsRegistry();
    public final MetricsTimeVaryingRate atomicIncrementTime = new MetricsTimeVaryingRate("atomicIncrementTime", this.registry);
    public final MetricsIntValue regions = new MetricsIntValue("regions", this.registry);
    public final MetricsLongValue blockCacheSize = new MetricsLongValue("blockCacheSize", this.registry);
    public final MetricsLongValue blockCacheFree = new MetricsLongValue("blockCacheFree", this.registry);
    public final MetricsLongValue blockCacheCount = new MetricsLongValue("blockCacheCount", this.registry);
    public final MetricsIntValue blockCacheHitRatio = new MetricsIntValue("blockCacheHitRatio", this.registry);
    private final MetricsRate requests = new MetricsRate("requests");
    public final MetricsIntValue stores = new MetricsIntValue("stores", this.registry);
    public final MetricsIntValue storefiles = new MetricsIntValue("storefiles", this.registry);
    public final MetricsIntValue storefileIndexSizeMB = new MetricsIntValue("storefileIndexSizeMB", this.registry);
    public final MetricsIntValue memstoreSizeMB = new MetricsIntValue("memstoreSizeMB", this.registry);

    public RegionServerMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"hbase");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"regionserver");
        String name = Thread.currentThread().getName();
        this.metricsRecord.setTag("RegionServer", name);
        context.registerUpdater((Updater)this);
        JvmMetrics.init((String)"RegionServer", (String)name);
        this.LOG.info((Object)"Initialized");
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        RegionServerMetrics regionServerMetrics = this;
        synchronized (regionServerMetrics) {
            this.stores.pushMetric(this.metricsRecord);
            this.storefiles.pushMetric(this.metricsRecord);
            this.storefileIndexSizeMB.pushMetric(this.metricsRecord);
            this.memstoreSizeMB.pushMetric(this.metricsRecord);
            this.regions.pushMetric(this.metricsRecord);
            this.requests.pushMetric(this.metricsRecord);
            this.blockCacheSize.pushMetric(this.metricsRecord);
            this.blockCacheFree.pushMetric(this.metricsRecord);
            this.blockCacheCount.pushMetric(this.metricsRecord);
            this.blockCacheHitRatio.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
        this.lastUpdate = System.currentTimeMillis();
    }

    public void resetAllMinMax() {
    }

    public float getRequests() {
        return this.requests.getPreviousIntervalValue();
    }

    public void incrementRequests(int inc) {
        this.requests.inc(inc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int seconds = (int)((System.currentTimeMillis() - this.lastUpdate) / 1000L);
        if (seconds == 0) {
            seconds = 1;
        }
        sb = Strings.appendKeyValue(sb, "request", Float.valueOf(this.requests.getPreviousIntervalValue()));
        sb = Strings.appendKeyValue(sb, "regions", this.regions.get());
        sb = Strings.appendKeyValue(sb, "stores", this.stores.get());
        sb = Strings.appendKeyValue(sb, "storefiles", this.storefiles.get());
        sb = Strings.appendKeyValue(sb, "storefileIndexSize", this.storefileIndexSizeMB.get());
        sb = Strings.appendKeyValue(sb, "memstoreSize", this.memstoreSizeMB.get());
        MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        sb = Strings.appendKeyValue(sb, "usedHeap", memory.getUsed() / 0x100000L);
        sb = Strings.appendKeyValue(sb, "maxHeap", memory.getMax() / 0x100000L);
        sb = Strings.appendKeyValue(sb, this.blockCacheSize.getName(), this.blockCacheSize.get());
        sb = Strings.appendKeyValue(sb, this.blockCacheFree.getName(), this.blockCacheFree.get());
        sb = Strings.appendKeyValue(sb, this.blockCacheCount.getName(), this.blockCacheCount.get());
        sb = Strings.appendKeyValue(sb, this.blockCacheHitRatio.getName(), this.blockCacheHitRatio.get());
        return sb.toString();
    }
}

