/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.RESTConstants;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class AbstractController
implements RESTConstants {
    protected Configuration conf;
    protected AbstractModel model;

    public void initialize(HBaseConfiguration conf, HBaseAdmin admin) {
        this.conf = conf;
        this.model = this.generateModel(conf, admin);
    }

    public abstract void get(Status var1, byte[][] var2, Map<String, String[]> var3) throws HBaseRestException;

    public abstract void post(Status var1, byte[][] var2, Map<String, String[]> var3, byte[] var4, IHBaseRestParser var5) throws HBaseRestException;

    public abstract void put(Status var1, byte[][] var2, Map<String, String[]> var3, byte[] var4, IHBaseRestParser var5) throws HBaseRestException;

    public abstract void delete(Status var1, byte[][] var2, Map<String, String[]> var3) throws HBaseRestException;

    protected abstract AbstractModel generateModel(HBaseConfiguration var1, HBaseAdmin var2);

    protected byte[][] getColumnsFromQueryMap(Map<String, String[]> queryMap) {
        Object columns = null;
        String[] columnArray = queryMap.get("column");
        if (columnArray != null) {
            columns = new byte[columnArray.length][];
            for (int i = 0; i < columnArray.length; ++i) {
                columns[i] = Bytes.toBytes(columnArray[i]);
            }
        }
        return columns;
    }
}

