/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class TRowResult
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("TRowResult");
    private static final TField ROW_FIELD_DESC = new TField("row", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 13, 2);
    public byte[] row;
    public static final int ROW = 1;
    public Map<byte[], TCell> columns;
    public static final int COLUMNS = 2;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("row", 3, new FieldValueMetaData(11)));
            this.put(2, new FieldMetaData("columns", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new StructMetaData(12, TCell.class))));
        }
    });

    public TRowResult() {
    }

    public TRowResult(byte[] row, Map<byte[], TCell> columns) {
        this();
        this.row = row;
        this.columns = columns;
    }

    public TRowResult(TRowResult other) {
        if (other.isSetRow()) {
            this.row = other.row;
        }
        if (other.isSetColumns()) {
            HashMap<byte[], TCell> __this__columns = new HashMap<byte[], TCell>();
            for (Map.Entry<byte[], TCell> other_element : other.columns.entrySet()) {
                byte[] other_element_key = other_element.getKey();
                TCell other_element_value = other_element.getValue();
                byte[] __this__columns_copy_key = other_element_key;
                TCell __this__columns_copy_value = new TCell(other_element_value);
                __this__columns.put(__this__columns_copy_key, __this__columns_copy_value);
            }
            this.columns = __this__columns;
        }
    }

    public TRowResult clone() {
        return new TRowResult(this);
    }

    public byte[] getRow() {
        return this.row;
    }

    public void setRow(byte[] row) {
        this.row = row;
    }

    public void unsetRow() {
        this.row = null;
    }

    public boolean isSetRow() {
        return this.row != null;
    }

    public void setRowIsSet(boolean value) {
        if (!value) {
            this.row = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public void putToColumns(byte[] key, TCell val) {
        if (this.columns == null) {
            this.columns = new HashMap<byte[], TCell>();
        }
        this.columns.put(key, val);
    }

    public Map<byte[], TCell> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<byte[], TCell> columns) {
        this.columns = columns;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetRow();
                    break;
                }
                this.setRow((byte[])value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((Map)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getRow();
            }
            case 2: {
                return this.getColumns();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetRow();
            }
            case 2: {
                return this.isSetColumns();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TRowResult) {
            return this.equals((TRowResult)that);
        }
        return false;
    }

    public boolean equals(TRowResult that) {
        if (that == null) {
            return false;
        }
        boolean this_present_row = this.isSetRow();
        boolean that_present_row = that.isSetRow();
        if (this_present_row || that_present_row) {
            if (!this_present_row || !that_present_row) {
                return false;
            }
            if (!Arrays.equals(this.row, that.row)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!((Object)this.columns).equals(that.columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.row = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 13) {
                        TMap _map4 = iprot.readMapBegin();
                        this.columns = new HashMap<byte[], TCell>(2 * _map4.size);
                        for (int _i5 = 0; _i5 < _map4.size; ++_i5) {
                            byte[] _key6 = iprot.readBinary();
                            TCell _val7 = new TCell();
                            _val7.read(iprot);
                            this.columns.put(_key6, _val7);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.row != null) {
            oprot.writeFieldBegin(ROW_FIELD_DESC);
            oprot.writeBinary(this.row);
            oprot.writeFieldEnd();
        }
        if (this.columns != null) {
            oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 12, this.columns.size()));
            for (Map.Entry<byte[], TCell> _iter8 : this.columns.entrySet()) {
                oprot.writeBinary(_iter8.getKey());
                _iter8.getValue().write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TRowResult(");
        boolean first = true;
        sb.append("row:");
        if (this.row == null) {
            sb.append("null");
        } else {
            sb.append(this.row);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(TRowResult.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        private Isset() {
        }
    }
}

