/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.FileSystemVersionException;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class FSUtils {
    private static final Log LOG = LogFactory.getLog(FSUtils.class);

    private FSUtils() {
    }

    public static boolean deleteDirectory(FileSystem fs, Path dir) throws IOException {
        return fs.exists(dir) ? fs.delete(dir, true) : false;
    }

    public Path checkdir(FileSystem fs, Path dir) throws IOException {
        if (!fs.exists(dir)) {
            fs.mkdirs(dir);
        }
        return dir;
    }

    public static Path create(FileSystem fs, Path p) throws IOException {
        if (fs.exists(p)) {
            throw new IOException("File already exists " + p.toString());
        }
        if (!fs.createNewFile(p)) {
            throw new IOException("Failed create of " + p);
        }
        return p;
    }

    public static void checkFileSystemAvailable(FileSystem fs) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            return;
        }
        IOException exception = null;
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        try {
            if (dfs.exists(new Path("/"))) {
                return;
            }
        }
        catch (IOException e) {
            exception = RemoteExceptionHandler.checkIOException(e);
        }
        try {
            fs.close();
        }
        catch (Exception e) {
            LOG.error((Object)"file system close failed: ", (Throwable)e);
        }
        IOException io = new IOException("File system is not available");
        io.initCause(exception);
        throw io;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(FileSystem fs, Path rootdir) throws IOException {
        Path versionFile = new Path(rootdir, "hbase.version");
        String version = null;
        if (fs.exists(versionFile)) {
            FSDataInputStream s = fs.open(versionFile);
            try {
                version = DataInputStream.readUTF((DataInput)s);
            }
            finally {
                s.close();
            }
        }
        return version;
    }

    public static void checkVersion(FileSystem fs, Path rootdir, boolean message) throws IOException {
        String version = FSUtils.getVersion(fs, rootdir);
        if (version == null) {
            if (!FSUtils.rootRegionExists(fs, rootdir)) {
                FSUtils.setVersion(fs, rootdir);
                return;
            }
        } else if (version.compareTo("7") == 0) {
            return;
        }
        String msg = "File system needs to be upgraded. Run the '${HBASE_HOME}/bin/hbase migrate' script.";
        if (message) {
            System.out.println("WARNING! " + msg);
        }
        throw new FileSystemVersionException(msg);
    }

    public static void setVersion(FileSystem fs, Path rootdir) throws IOException {
        FSUtils.setVersion(fs, rootdir, "7");
    }

    public static void setVersion(FileSystem fs, Path rootdir, String version) throws IOException {
        FSDataOutputStream s = fs.create(new Path(rootdir, "hbase.version"));
        s.writeUTF(version);
        s.close();
        LOG.debug((Object)("Created version file at " + rootdir.toString() + " set its version at:" + version));
    }

    public static void validateRootPath(Path root) throws IOException {
        try {
            URI rootURI = new URI(root.toString());
            String scheme = rootURI.getScheme();
            if (scheme == null) {
                throw new IOException("Root directory does not contain a scheme");
            }
        }
        catch (URISyntaxException e) {
            IOException io = new IOException("Root directory path is not a valid URI");
            io.initCause(e);
            throw io;
        }
    }

    public static String getPath(Path p) {
        return p.toUri().getPath();
    }

    public static Path getRootDir(HBaseConfiguration c) throws IOException {
        Path rootdir;
        FileSystem fs = FileSystem.get((Configuration)c);
        if (!fs.exists(rootdir = fs.makeQualified(new Path(c.get("hbase.rootdir"))))) {
            String message = "HBase root directory " + rootdir.toString() + " does not exist.";
            LOG.error((Object)message);
            throw new FileNotFoundException(message);
        }
        return rootdir;
    }

    public static boolean rootRegionExists(FileSystem fs, Path rootdir) throws IOException {
        Path rootRegionDir = HRegion.getRegionDir(rootdir, HRegionInfo.ROOT_REGIONINFO);
        return fs.exists(rootRegionDir);
    }

    public static boolean isMajorCompacted(FileSystem fs, Path hbaseRootDir) throws IOException {
        FileStatus[] tableDirs = fs.listStatus(hbaseRootDir, (PathFilter)new DirFilter(fs));
        for (int i = 0; i < tableDirs.length; ++i) {
            Path d = tableDirs[i].getPath();
            if (d.getName().equals(".logs")) continue;
            FileStatus[] regionDirs = fs.listStatus(d, (PathFilter)new DirFilter(fs));
            for (int j = 0; j < regionDirs.length; ++j) {
                Path dd = regionDirs[j].getPath();
                if (dd.equals((Object)"compaction.dir")) continue;
                FileStatus[] familyDirs = fs.listStatus(dd, (PathFilter)new DirFilter(fs));
                for (int k = 0; k < familyDirs.length; ++k) {
                    Path family = familyDirs[k].getPath();
                    FileStatus[] familyStatus = fs.listStatus(family);
                    if (familyStatus.length <= 1) continue;
                    LOG.debug((Object)(family.toString() + " has " + familyStatus.length + " files."));
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isPre020FileLayout(FileSystem fs, Path hbaseRootDir) throws IOException {
        Path mapfiles = new Path(new Path(new Path(new Path(hbaseRootDir, "-ROOT-"), "70236052"), "info"), "mapfiles");
        return fs.exists(mapfiles);
    }

    public static boolean isMajorCompactedPre020(FileSystem fs, Path hbaseRootDir) throws IOException {
        FileStatus[] tableDirs = fs.listStatus(hbaseRootDir, (PathFilter)new DirFilter(fs));
        for (int i = 0; i < tableDirs.length; ++i) {
            Path d = tableDirs[i].getPath();
            if (d.getName().equals(".logs")) continue;
            FileStatus[] regionDirs = fs.listStatus(d, (PathFilter)new DirFilter(fs));
            for (int j = 0; j < regionDirs.length; ++j) {
                Path dd = regionDirs[j].getPath();
                if (dd.equals((Object)"compaction.dir")) continue;
                FileStatus[] familyDirs = fs.listStatus(dd, (PathFilter)new DirFilter(fs));
                for (int k = 0; k < familyDirs.length; ++k) {
                    Path family = familyDirs[k].getPath();
                    FileStatus[] infoAndMapfile = fs.listStatus(family);
                    if (infoAndMapfile.length != 0 && infoAndMapfile.length != 2) {
                        LOG.debug((Object)(family.toString() + " has more than just info and mapfile: " + infoAndMapfile.length));
                        return false;
                    }
                    for (int ll = 0; ll < 2; ++ll) {
                        if (infoAndMapfile[ll].getPath().getName().equals("info") || infoAndMapfile[ll].getPath().getName().equals("mapfiles")) continue;
                        LOG.debug((Object)("Unexpected directory name: " + infoAndMapfile[ll].getPath()));
                        return false;
                    }
                    FileStatus[] familyStatus = fs.listStatus(new Path(family, "mapfiles"));
                    if (familyStatus.length <= 1) continue;
                    LOG.debug((Object)(family.toString() + " has " + familyStatus.length + " files."));
                    return false;
                }
            }
        }
        return true;
    }

    public static class DirFilter
    implements PathFilter {
        private final FileSystem fs;

        public DirFilter(FileSystem fs) {
            this.fs = fs;
        }

        public boolean accept(Path p) {
            boolean isdir = false;
            try {
                isdir = this.fs.getFileStatus(p).isDir();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return isdir;
        }
    }
}

