/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1.svd;

import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.kddcup.track1.svd.FactorizablePreferences;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;

public class DataModelFactorizablePreferences
implements FactorizablePreferences {
    private final FastIDSet userIDs;
    private final FastIDSet itemIDs;
    private final List<Preference> preferences;
    private final float minPreference;
    private final float maxPreference;

    public DataModelFactorizablePreferences(DataModel dataModel) {
        this.minPreference = dataModel.getMinPreference();
        this.maxPreference = dataModel.getMaxPreference();
        try {
            this.userIDs = new FastIDSet(dataModel.getNumUsers());
            this.itemIDs = new FastIDSet(dataModel.getNumItems());
            this.preferences = new ArrayList<Preference>();
            LongPrimitiveIterator userIDsIterator = dataModel.getUserIDs();
            while (userIDsIterator.hasNext()) {
                long userID = userIDsIterator.nextLong();
                this.userIDs.add(userID);
                for (Preference preference : dataModel.getPreferencesFromUser(userID)) {
                    this.itemIDs.add(preference.getItemID());
                    this.preferences.add((Preference)new GenericPreference(userID, preference.getItemID(), preference.getValue()));
                }
            }
        }
        catch (TasteException te) {
            throw new IllegalStateException("Unable to create factorizable preferences!", te);
        }
    }

    @Override
    public LongPrimitiveIterator getUserIDs() {
        return this.userIDs.iterator();
    }

    @Override
    public LongPrimitiveIterator getItemIDs() {
        return this.itemIDs.iterator();
    }

    @Override
    public Iterable<Preference> getPreferences() {
        return this.preferences;
    }

    @Override
    public float getMinPreference() {
        return this.minPreference;
    }

    @Override
    public float getMaxPreference() {
        return this.maxPreference;
    }

    @Override
    public int numUsers() {
        return this.userIDs.size();
    }

    @Override
    public int numItems() {
        return this.itemIDs.size();
    }

    @Override
    public int numPreferences() {
        return this.preferences.size();
    }
}

