/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.Charsets;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.stats.OnlineSummarizer;
import org.apache.mahout.vectorizer.encoders.ConstantValueEncoder;
import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleCsvExamples {
    public static final char SEPARATOR_CHAR = '\t';
    private static final int FIELDS = 100;
    private static final Logger log = LoggerFactory.getLogger(SimpleCsvExamples.class);

    private SimpleCsvExamples() {
    }

    public static void main(String[] args) throws IOException {
        FeatureVectorEncoder[] encoder = new FeatureVectorEncoder[100];
        for (int i = 0; i < 100; ++i) {
            encoder[i] = new ConstantValueEncoder("v1");
        }
        OnlineSummarizer[] s = new OnlineSummarizer[100];
        for (int i = 0; i < 100; ++i) {
            s[i] = new OnlineSummarizer();
        }
        long t0 = System.currentTimeMillis();
        DenseVector v = new DenseVector(1000);
        if ("--generate".equals(args[0])) {
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(args[2])), Charsets.UTF_8));){
                int n = Integer.parseInt(args[1]);
                for (int i = 0; i < n; ++i) {
                    Line x = Line.generate();
                    out.println(x);
                }
            }
        }
        if ("--parse".equals(args[0])) {
            try (BufferedReader in = Files.newReader((File)new File(args[1]), (Charset)Charsets.UTF_8);){
                String line = in.readLine();
                while (line != null) {
                    v.assign(0.0);
                    Line x = new Line(line);
                    for (int i = 0; i < 100; ++i) {
                        s[i].add(x.getDouble(i));
                        encoder[i].addToVector(x.get(i), (Vector)v);
                    }
                    line = in.readLine();
                }
            }
            String separator = "";
            for (int i = 0; i < 100; ++i) {
                System.out.printf("%s%.3f", separator, s[i].getMean());
                separator = ",";
            }
        } else if ("--fast".equals(args[0])) {
            try (FastLineReader in = new FastLineReader(new FileInputStream(args[1]));){
                FastLine line = in.read();
                while (line != null) {
                    v.assign(0.0);
                    for (int i = 0; i < 100; ++i) {
                        double z = line.getDouble(i);
                        s[i].add(z);
                        encoder[i].addToVector((byte[])null, z, (Vector)v);
                    }
                    line = in.read();
                }
            }
            String separator = "";
            for (int i = 0; i < 100; ++i) {
                System.out.printf("%s%.3f", separator, s[i].getMean());
                separator = ",";
            }
        }
        System.out.printf("\nElapsed time = %.3f%n", (double)(System.currentTimeMillis() - t0) / 1000.0);
    }

    private static final class FastLineReader
    implements Closeable {
        private final InputStream in;
        private final ByteBuffer buf = ByteBuffer.allocate(100000);

        private FastLineReader(InputStream in) throws IOException {
            this.in = in;
            this.buf.limit(0);
            this.fillBuffer();
        }

        public FastLine read() throws IOException {
            this.fillBuffer();
            if (this.buf.remaining() > 0) {
                return FastLine.read(this.buf);
            }
            return null;
        }

        private void fillBuffer() throws IOException {
            if (this.buf.remaining() < 10000) {
                this.buf.compact();
                int n = this.in.read(this.buf.array(), this.buf.position(), this.buf.remaining());
                if (n == -1) {
                    this.buf.flip();
                } else {
                    this.buf.limit(this.buf.position() + n);
                    this.buf.position(0);
                }
            }
        }

        @Override
        public void close() {
            try {
                Closeables.close((Closeable)this.in, (boolean)true);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final class FastLine {
        private final ByteBuffer base;
        private final IntArrayList start = new IntArrayList();
        private final IntArrayList length = new IntArrayList();

        private FastLine(ByteBuffer base) {
            this.base = base;
        }

        public static FastLine read(ByteBuffer buf) {
            FastLine r = new FastLine(buf);
            r.start.add(buf.position());
            int offset = buf.position();
            while (offset < buf.limit()) {
                byte ch = buf.get();
                offset = buf.position();
                switch (ch) {
                    case 10: {
                        r.length.add(offset - r.start.get(r.length.size()) - 1);
                        return r;
                    }
                    case 9: {
                        r.length.add(offset - r.start.get(r.length.size()) - 1);
                        r.start.add(offset);
                        break;
                    }
                }
            }
            throw new IllegalArgumentException("Not enough bytes in buffer");
        }

        public double getDouble(int field) {
            int offset = this.start.get(field);
            int size = this.length.get(field);
            switch (size) {
                case 1: {
                    return this.base.get(offset) - 48;
                }
                case 2: {
                    return (this.base.get(offset) - 48) * 10 + this.base.get(offset + 1) - 48;
                }
            }
            double r = 0.0;
            for (int i = 0; i < size; ++i) {
                r = 10.0 * r + (double)this.base.get(offset + i) - 48.0;
            }
            return r;
        }
    }

    private static final class Line {
        private static final Splitter ON_TABS = Splitter.on((char)'\t').trimResults();
        public static final Joiner WITH_COMMAS = Joiner.on((char)'\t');
        public static final Random RAND = RandomUtils.getRandom();
        private final List<String> data;

        private Line(CharSequence line) {
            this.data = Lists.newArrayList((Iterable)ON_TABS.split(line));
        }

        private Line() {
            this.data = new ArrayList<String>();
        }

        public double getDouble(int field) {
            return Double.parseDouble(this.data.get(field));
        }

        public static Line generate() {
            Line r = new Line();
            for (int i = 0; i < 100; ++i) {
                double mean = (i + 1) * 257 % 50 + 1;
                r.data.add(Integer.toString(Line.randomValue(mean)));
            }
            return r;
        }

        private static int randomValue(double mean) {
            return (int)(-mean * Math.log1p(-RAND.nextDouble()));
        }

        public String toString() {
            return WITH_COMMAS.join(this.data);
        }

        public String get(int field) {
            return this.data.get(field);
        }
    }
}

