/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd.bankmarketing;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.ConstantValueEncoder;
import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;
import org.apache.mahout.vectorizer.encoders.StaticWordValueEncoder;

public class TelephoneCall {
    public static final int FEATURES = 100;
    private static final ConstantValueEncoder interceptEncoder = new ConstantValueEncoder("intercept");
    private static final FeatureVectorEncoder featureEncoder = new StaticWordValueEncoder("feature");
    private RandomAccessSparseVector vector;
    private Map<String, String> fields = new LinkedHashMap<String, String>();

    public TelephoneCall(Iterable<String> fieldNames, Iterable<String> values) {
        this.vector = new RandomAccessSparseVector(100);
        Iterator<String> value = values.iterator();
        interceptEncoder.addToVector("1", (Vector)this.vector);
        block27: for (String name : fieldNames) {
            String fieldValue = value.next();
            this.fields.put(name, fieldValue);
            switch (name) {
                case "age": {
                    double v = Double.parseDouble(fieldValue);
                    featureEncoder.addToVector(name, Math.log(v), (Vector)this.vector);
                    continue block27;
                }
                case "balance": {
                    double v = Double.parseDouble(fieldValue);
                    if (v < -2000.0) {
                        v = -2000.0;
                    }
                    featureEncoder.addToVector(name, Math.log(v + 2001.0) - 8.0, (Vector)this.vector);
                    continue block27;
                }
                case "duration": {
                    double v = Double.parseDouble(fieldValue);
                    featureEncoder.addToVector(name, Math.log(v + 1.0) - 5.0, (Vector)this.vector);
                    continue block27;
                }
                case "pdays": {
                    double v = Double.parseDouble(fieldValue);
                    featureEncoder.addToVector(name, Math.log(v + 2.0), (Vector)this.vector);
                    continue block27;
                }
                case "job": 
                case "marital": 
                case "education": 
                case "default": 
                case "housing": 
                case "loan": 
                case "contact": 
                case "campaign": 
                case "previous": 
                case "poutcome": {
                    featureEncoder.addToVector(name + ":" + fieldValue, 1.0, (Vector)this.vector);
                    continue block27;
                }
                case "day": 
                case "month": 
                case "y": {
                    continue block27;
                }
            }
            throw new IllegalArgumentException(String.format("Bad field name: %s", name));
        }
    }

    public Vector asVector() {
        return this.vector;
    }

    public int getTarget() {
        return this.fields.get("y").equals("no") ? 0 : 1;
    }
}

