/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce;

import java.io.IOException;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.df.DFUtils;
import org.apache.mahout.classifier.df.DecisionForest;
import org.apache.mahout.classifier.df.builder.DecisionTreeBuilder;
import org.apache.mahout.classifier.df.builder.TreeBuilder;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.mapreduce.inmem.InMemBuilder;
import org.apache.mahout.classifier.df.mapreduce.partial.PartialBuilder;
import org.apache.mahout.common.CommandLineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildForest
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(BuildForest.class);
    private Path dataPath;
    private Path datasetPath;
    private Path outputPath;
    private Integer m;
    private boolean complemented;
    private Integer minSplitNum;
    private Double minVarianceProportion;
    private int nbTrees;
    private Long seed;
    private boolean isPartial;

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption dataOpt = obuilder.withLongName("data").withShortName("d").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Data path").create();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("dataset").withMinimum(1).withMaximum(1).create()).withDescription("Dataset path").create();
        DefaultOption selectionOpt = obuilder.withLongName("selection").withShortName("sl").withRequired(false).withArgument(abuilder.withName("m").withMinimum(1).withMaximum(1).create()).withDescription("Optional, Number of variables to select randomly at each tree-node.\nFor classification problem, the default is square root of the number of explanatory variables.\nFor regression problem, the default is 1/3 of the number of explanatory variables.").create();
        DefaultOption noCompleteOpt = obuilder.withLongName("no-complete").withShortName("nc").withRequired(false).withDescription("Optional, The tree is not complemented").create();
        DefaultOption minSplitOpt = obuilder.withLongName("minsplit").withShortName("ms").withRequired(false).withArgument(abuilder.withName("minsplit").withMinimum(1).withMaximum(1).create()).withDescription("Optional, The tree-node is not divided, if the branching data size is smaller than this value.\nThe default is 2.").create();
        DefaultOption minPropOpt = obuilder.withLongName("minprop").withShortName("mp").withRequired(false).withArgument(abuilder.withName("minprop").withMinimum(1).withMaximum(1).create()).withDescription("Optional, The tree-node is not divided, if the proportion of the variance of branching data is smaller than this value.\nIn the case of a regression problem, this value is used. The default is 1/1000(0.001).").create();
        DefaultOption seedOpt = obuilder.withLongName("seed").withShortName("sd").withRequired(false).withArgument(abuilder.withName("seed").withMinimum(1).withMaximum(1).create()).withDescription("Optional, seed value used to initialise the Random number generator").create();
        DefaultOption partialOpt = obuilder.withLongName("partial").withShortName("p").withRequired(false).withDescription("Optional, use the Partial Data implementation").create();
        DefaultOption nbtreesOpt = obuilder.withLongName("nbtrees").withShortName("t").withRequired(true).withArgument(abuilder.withName("nbtrees").withMinimum(1).withMaximum(1).create()).withDescription("Number of trees to grow").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withShortName("o").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Output path, will contain the Decision Forest").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withShortName("h").withDescription("Print out help").create();
        Group group = gbuilder.withName("Options").withOption((Option)dataOpt).withOption((Option)datasetOpt).withOption((Option)selectionOpt).withOption((Option)noCompleteOpt).withOption((Option)minSplitOpt).withOption((Option)minPropOpt).withOption((Option)seedOpt).withOption((Option)partialOpt).withOption((Option)nbtreesOpt).withOption((Option)outputOpt).withOption((Option)helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption("help")) {
                CommandLineUtil.printHelp((Group)group);
                return -1;
            }
            this.isPartial = cmdLine.hasOption((Option)partialOpt);
            String dataName = cmdLine.getValue((Option)dataOpt).toString();
            String datasetName = cmdLine.getValue((Option)datasetOpt).toString();
            String outputName = cmdLine.getValue((Option)outputOpt).toString();
            this.nbTrees = Integer.parseInt(cmdLine.getValue((Option)nbtreesOpt).toString());
            if (cmdLine.hasOption((Option)selectionOpt)) {
                this.m = Integer.parseInt(cmdLine.getValue((Option)selectionOpt).toString());
            }
            boolean bl = this.complemented = !cmdLine.hasOption((Option)noCompleteOpt);
            if (cmdLine.hasOption((Option)minSplitOpt)) {
                this.minSplitNum = Integer.parseInt(cmdLine.getValue((Option)minSplitOpt).toString());
            }
            if (cmdLine.hasOption((Option)minPropOpt)) {
                this.minVarianceProportion = Double.parseDouble(cmdLine.getValue((Option)minPropOpt).toString());
            }
            if (cmdLine.hasOption((Option)seedOpt)) {
                this.seed = Long.valueOf(cmdLine.getValue((Option)seedOpt).toString());
            }
            if (log.isDebugEnabled()) {
                log.debug("data : {}", (Object)dataName);
                log.debug("dataset : {}", (Object)datasetName);
                log.debug("output : {}", (Object)outputName);
                log.debug("m : {}", (Object)this.m);
                log.debug("complemented : {}", (Object)this.complemented);
                log.debug("minSplitNum : {}", (Object)this.minSplitNum);
                log.debug("minVarianceProportion : {}", (Object)this.minVarianceProportion);
                log.debug("seed : {}", (Object)this.seed);
                log.debug("nbtrees : {}", (Object)this.nbTrees);
                log.debug("isPartial : {}", (Object)this.isPartial);
            }
            this.dataPath = new Path(dataName);
            this.datasetPath = new Path(datasetName);
            this.outputPath = new Path(outputName);
        }
        catch (OptionException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
            return -1;
        }
        this.buildForest();
        return 0;
    }

    private void buildForest() throws IOException, ClassNotFoundException, InterruptedException {
        PartialBuilder forestBuilder;
        FileSystem ofs = this.outputPath.getFileSystem(this.getConf());
        if (ofs.exists(this.outputPath)) {
            log.error("Output path already exists");
            return;
        }
        DecisionTreeBuilder treeBuilder = new DecisionTreeBuilder();
        if (this.m != null) {
            treeBuilder.setM(this.m.intValue());
        }
        treeBuilder.setComplemented(this.complemented);
        if (this.minSplitNum != null) {
            treeBuilder.setMinSplitNum(this.minSplitNum.intValue());
        }
        if (this.minVarianceProportion != null) {
            treeBuilder.setMinVarianceProportion(this.minVarianceProportion.doubleValue());
        }
        if (this.isPartial) {
            log.info("Partial Mapred implementation");
            forestBuilder = new PartialBuilder((TreeBuilder)treeBuilder, this.dataPath, this.datasetPath, this.seed, this.getConf());
        } else {
            log.info("InMem Mapred implementation");
            forestBuilder = new InMemBuilder((TreeBuilder)treeBuilder, this.dataPath, this.datasetPath, this.seed, this.getConf());
        }
        forestBuilder.setOutputDirName(this.outputPath.getName());
        log.info("Building the forest...");
        long time = System.currentTimeMillis();
        DecisionForest forest = forestBuilder.build(this.nbTrees);
        time = System.currentTimeMillis() - time;
        log.info("Build Time: {}", (Object)DFUtils.elapsedTime((long)time));
        log.info("Forest num Nodes: {}", (Object)forest.nbNodes());
        log.info("Forest mean num Nodes: {}", (Object)forest.meanNbNodes());
        log.info("Forest mean max Depth: {}", (Object)forest.meanMaxDepth());
        Path forestPath = new Path(this.outputPath, "forest.seq");
        log.info("Storing the forest in: {}", (Object)forestPath);
        DFUtils.storeWritable((Configuration)this.getConf(), (Path)forestPath, (Writable)forest);
    }

    protected static Data loadData(Configuration conf, Path dataPath, Dataset dataset) throws IOException {
        log.info("Loading the data...");
        FileSystem fs = dataPath.getFileSystem(conf);
        Data data = DataLoader.loadData((Dataset)dataset, (FileSystem)fs, (Path)dataPath);
        log.info("Data Loaded");
        return data;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new BuildForest(), (String[])args);
    }
}

